/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.menu.CorModel;
import org.rosuda.deducer.menu.CorOptions;
import org.rosuda.deducer.menu.CorPlots;
import org.rosuda.deducer.menu.SubsetDialog;
import org.rosuda.deducer.menu.SubsetPanel;
import org.rosuda.deducer.toolkit.AddButton;
import org.rosuda.deducer.toolkit.AssumptionIcon;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.toolkit.RemoveButton;
import org.rosuda.deducer.toolkit.VariableSelector;

public class CorDialog
extends JDialog
implements ActionListener {
    private VariableSelector variableSelector;
    private JButton help;
    private JButton plots;
    private JButton options;
    private JPanel typePanel;
    private SubsetPanel subset;
    private JPanel subsetPanel;
    private DJList with;
    private JScrollPane withScroller;
    private JButton outlierAssump;
    private JButton removeWith;
    private JButton addWith;
    private JButton removeVar;
    private JButton addVar;
    private JButton linearAssump;
    private JButton largeSampeAssump2;
    private JButton monoAssump;
    private JButton monoAssump1;
    private JRadioButton spearman;
    private JSeparator sep1;
    private JButton largeSampleAssump1;
    private JRadioButton kendall;
    private JSeparator sep;
    private JButton largeSampleAssump;
    private JRadioButton pearson;
    private JPanel okayCancel;
    private JPanel withVariablesPanel;
    private DJList variables;
    private JScrollPane variableScroller;
    private JPanel variablePanel;
    private CorModel model;
    private static CorModel lastModel;

    public CorDialog(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
        this.setModal(true);
        if (lastModel == null) {
            this.reset();
        } else {
            this.setModel(lastModel);
        }
        this.variableSelector.getJComboBox().addActionListener(this);
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.help = new HelpButton("pmwiki.php?n=Main.Correlation");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(906, 60, 960, 15, 0, 0, 1, 1));
            this.help.setPreferredSize(new Dimension(36, 36));
            this.plots = new JButton();
            this.getContentPane().add((Component)this.plots, new AnchorConstraint(135, 877, 178, 772, 1, 1, 0, 0));
            this.plots.setText("Plots");
            this.plots.setPreferredSize(new Dimension(84, 22));
            this.plots.addActionListener(this);
            this.options = new JButton();
            this.getContentPane().add((Component)this.options, new AnchorConstraint(202, 877, 245, 772, 1, 1, 0, 0));
            this.options.setText("Options");
            this.options.setPreferredSize(new Dimension(84, 22));
            this.options.addActionListener(this);
            this.typePanel = new JPanel();
            this.getContentPane().add((Component)this.typePanel, new AnchorConstraint(385, 12, 862, 671, 1, 2, 0, 1));
            this.typePanel.setBorder(BorderFactory.createTitledBorder("Correlation type"));
            this.typePanel.setLayout(null);
            this.typePanel.setPreferredSize(new Dimension(251, 242));
            this.pearson = new JRadioButton();
            this.typePanel.add(this.pearson);
            this.pearson.setText("Pearson's");
            this.pearson.setBounds(17, 32, 160, 19);
            this.largeSampleAssump = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
            this.typePanel.add(this.largeSampleAssump);
            this.largeSampleAssump.setBounds(34, 51, 27, 27);
            this.outlierAssump = new AssumptionIcon("/icons/outlier_assump.png", "No Outliers", this, "No Outliers");
            this.typePanel.add(this.outlierAssump);
            this.outlierAssump.setBounds(60, 51, 27, 27);
            this.sep = new JSeparator();
            this.typePanel.add(this.sep);
            this.sep.setBounds(48, 90, 129, 6);
            this.kendall = new JRadioButton();
            this.typePanel.add(this.kendall);
            this.kendall.setText("Kendall's");
            this.kendall.setBounds(17, 102, 160, 19);
            this.largeSampleAssump1 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
            this.typePanel.add(this.largeSampleAssump1);
            this.largeSampleAssump1.setBounds(34, 121, 27, 27);
            this.monoAssump1 = new AssumptionIcon("/icons/func_assump.png", "Monotonic", null, "Monotonic");
            this.typePanel.add(this.monoAssump1);
            this.monoAssump1.setBounds(65, 121, 27, 27);
            this.sep1 = new JSeparator();
            this.typePanel.add(this.sep1);
            this.sep1.setBounds(48, 160, 129, 5);
            this.spearman = new JRadioButton();
            this.typePanel.add(this.spearman);
            this.spearman.setText("Spearman's");
            this.spearman.setBounds(17, 171, 160, 19);
            this.largeSampeAssump2 = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
            this.typePanel.add(this.largeSampeAssump2);
            this.largeSampeAssump2.setBounds(34, 190, 27, 27);
            this.monoAssump = new AssumptionIcon("/icons/func_assump.png", "Monotonic", null, "Monotonic");
            this.typePanel.add(this.monoAssump);
            this.monoAssump.setBounds(65, 190, 27, 27);
            this.linearAssump = new AssumptionIcon("/icons/func_assump.png", "Linear Relationship", null, "Linear Relationship");
            this.typePanel.add(this.linearAssump);
            this.linearAssump.setBounds(87, 51, 27, 27);
            this.withVariablesPanel = new JPanel();
            Serializable serializable = new BorderLayout();
            this.withVariablesPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add((Component)this.withVariablesPanel, new AnchorConstraint(385, 656, 716, 381, 1, 1, 1, 1));
            this.withVariablesPanel.setPreferredSize(new Dimension(219, 168));
            this.withVariablesPanel.setBorder(BorderFactory.createTitledBorder("With (Optional)"));
            this.withScroller = new JScrollPane();
            this.withVariablesPanel.add((Component)this.withScroller, "Center");
            DefaultListModel defaultListModel = new DefaultListModel();
            this.with = new DJList();
            this.withScroller.setViewportView(this.with);
            this.with.setModel(defaultListModel);
            this.variablePanel = new JPanel();
            serializable = new BorderLayout();
            this.variablePanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add((Component)this.variablePanel, new AnchorConstraint(16, 656, 385, 381, 1, 1, 1, 1));
            this.variablePanel.setBorder(BorderFactory.createTitledBorder("Variables"));
            this.variablePanel.setPreferredSize(new Dimension(219, 187));
            this.variableScroller = new JScrollPane();
            this.variablePanel.add((Component)this.variableScroller, "Center");
            defaultListModel = new DefaultListModel();
            this.variables = new DJList();
            this.variableScroller.setViewportView(this.variables);
            this.variables.setModel(defaultListModel);
            this.variableSelector = new VariableSelector();
            this.getContentPane().add((Component)this.variableSelector, new AnchorConstraint(16, 300, 862, 15, 1, 1, 1, 1));
            this.variableSelector.setPreferredSize(new Dimension(219, 400));
            this.subsetPanel = new JPanel();
            serializable = new BorderLayout();
            this.subsetPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add((Component)this.subsetPanel, new AnchorConstraint(716, 656, 862, 381, 1, 1, 1, 1));
            this.subsetPanel.setPreferredSize(new Dimension(219, 74));
            this.subsetPanel.setBorder(BorderFactory.createTitledBorder("Subset"));
            this.subset = new SubsetPanel(this.variableSelector.getJComboBox());
            this.subsetPanel.add((Component)this.subset, "Center");
            this.okayCancel = new OkayCancelPanel(true, true, this);
            this.getContentPane().add((Component)this.okayCancel, new AnchorConstraint(874, 985, 977, 539, 0, 1, 1, 0));
            this.okayCancel.setPreferredSize(new Dimension(356, 52));
            this.addVar = new AddButton("Add", this.variableSelector, (JList)this.variables);
            this.getContentPane().add((Component)this.addVar, new AnchorConstraint(135, 366, 210, 318, 1, 1, 1, 1));
            this.addVar.setPreferredSize(new Dimension(38, 38));
            this.removeVar = new RemoveButton("Remove", this.variableSelector, (JList)this.variables);
            this.getContentPane().add((Component)this.removeVar, new AnchorConstraint(210, 366, 285, 318, 1, 1, 1, 1));
            this.removeVar.setPreferredSize(new Dimension(38, 38));
            this.addWith = new AddButton("Add", this.variableSelector, (JList)this.with);
            this.getContentPane().add((Component)this.addWith, new AnchorConstraint(488, 366, 563, 318, 1, 1, 1, 1));
            this.addWith.setPreferredSize(new Dimension(38, 38));
            this.removeWith = new RemoveButton("Remove", this.variableSelector, (JList)this.with);
            this.getContentPane().add((Component)this.removeWith, new AnchorConstraint(563, 366, 638, 318, 1, 1, 1, 1));
            this.removeWith.setPreferredSize(new Dimension(38, 38));
            serializable = new ButtonGroup();
            ((ButtonGroup)serializable).add(this.pearson);
            ((ButtonGroup)serializable).add(this.spearman);
            ((ButtonGroup)serializable).add(this.kendall);
            this.setTitle("Correlation");
            this.setMinimumSize(new Dimension(500, 527));
            this.setSize(798, 529);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void setDataName(String string) {
        if (!string.equals(this.variableSelector.getSelectedData())) {
            this.variableSelector.setSelectedData(string);
        }
    }

    public void reset() {
        CorModel corModel = new CorModel();
        this.setModel(corModel);
    }

    public void setModel(CorModel corModel) {
        this.model = corModel;
        this.variables.setModel(new DefaultListModel());
        this.with.setModel(new DefaultListModel());
        this.variableSelector.reset();
        if (corModel.dataName != null) {
            this.variableSelector.setSelectedData(corModel.dataName);
            boolean bl = this.variableSelector.removeAll(corModel.variables);
            if (!bl) {
                this.reset();
                return;
            }
            this.variables.setModel(corModel.variables);
            bl = this.variableSelector.removeAll(corModel.with);
            if (!bl) {
                this.reset();
                return;
            }
            this.with.setModel(corModel.with);
            if (corModel.subset == "" || RController.isValidSubsetExp((String)corModel.subset, (String)corModel.dataName)) {
                this.subset.setText(corModel.subset);
            }
        }
        if (corModel.method.equals("pearson")) {
            this.pearson.setSelected(true);
        } else if (corModel.method.equals("spearman")) {
            this.spearman.setSelected(true);
        } else {
            this.kendall.setSelected(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Run") {
            this.model.method = this.pearson.isSelected() ? "pearson" : (this.spearman.isSelected() ? "spearman" : "kendall");
            this.model.variables = (DefaultListModel)this.variables.getModel();
            this.model.with = (DefaultListModel)this.with.getModel();
            this.model.dataName = this.variableSelector.getSelectedData();
            this.model.subset = this.subset.getText();
            boolean bl = true;
            bl = this.model.run();
            if (bl) {
                SubsetDialog.addToHistory(this.model.dataName, this.model.subset);
                Deducer.setRecentData(this.model.dataName);
                lastModel = this.model;
                this.dispose();
            }
        } else if (string == "Cancel") {
            this.dispose();
        } else if (string == "Reset") {
            this.reset();
        } else if (string == "Options") {
            CorOptions corOptions = new CorOptions(this, this.model.options);
            corOptions.setLocationRelativeTo(this);
            corOptions.setVisible(true);
        } else if (string == "Plots") {
            CorPlots corPlots = new CorPlots(this, this.model.plots, this.with.getModel().getSize() > 0);
            corPlots.setLocationRelativeTo(this);
            corPlots.setVisible(true);
        } else if (string == "comboBoxChanged") {
            this.reset();
        }
    }
}

