/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.trace;

import dr.evomodel.trace.CnCsPerSiteAnalysis;
import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceException;
import dr.inference.trace.TraceList;
import dr.math.EmpiricalBayesPoissonSmoother;
import dr.stats.DiscreteStatistics;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.util.HeapSort;
import dr.util.NumberFormatter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class CnCsToDnDsPerSiteAnalysis
implements Citable {
    public static final String CNCS_TO_DNDS_PER_SITE_ANALYSIS = "cNcSTodNdSPerSiteAnalysis";
    public static final String BURN_IN = "burnin";
    public static final String CUTOFF = "cutoff";
    public static final String PROPORTION = "proportion";
    public static final String INCLUDE_SIGNIFICANT_SYMBOL = "includeSymbol";
    public static final String INCLUDE_SIGNIFICANCE_LEVEL = "includeLevel";
    public static final String INCLUDE_SITE_CLASSIFICATION = "includeClassification";
    public static final String SIGNIFICANCE_TEST = "test";
    public static final String SEPARATOR_STRING = "separator";
    public static final String INCLUDE_SIMULATION_OUTCOME = "simulationOutcome";
    public static final String INCLUDE_HPD = "includeHPD";
    public static final String SITE_SIMULATION = "siteSimulation";
    public static final String CN = "CN";
    public static final String CS = "CS";
    public static final String USE_SAMPLE = "sample";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("fileNameCN", true), AttributeRule.newStringRule("fileNameCS", true), AttributeRule.newDoubleRule("cutoff", true), AttributeRule.newDoubleRule("proportion", true), AttributeRule.newIntegerRule("burnin", true), AttributeRule.newBooleanRule("sample", true), AttributeRule.newBooleanRule("includeHPD", true), AttributeRule.newBooleanRule("includeSymbol", true), AttributeRule.newBooleanRule("includeLevel", true), AttributeRule.newBooleanRule("includeClassification", true), AttributeRule.newBooleanRule("simulationOutcome", true), AttributeRule.newStringRule("siteSimulation", true), AttributeRule.newStringRule("test", true), AttributeRule.newStringRule("separator", true)};

        @Override
        public String getParserName() {
            return CnCsToDnDsPerSiteAnalysis.CNCS_TO_DNDS_PER_SITE_ANALYSIS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute("fileNameCN");
            String string2 = xMLObject.getStringAttribute("fileNameCS");
            try {
                long l;
                File file = new File(string);
                File file2 = new File(string2);
                String string3 = file.getName();
                String string4 = file2.getName();
                String string5 = file.getParent();
                String string6 = file2.getParent();
                if (!file.isAbsolute()) {
                    string5 = System.getProperty("user.dir");
                }
                if (!file2.isAbsolute()) {
                    string6 = System.getProperty("user.dir");
                }
                file = new File(string5, string3);
                file2 = new File(string6, string4);
                string = file.getAbsolutePath();
                string2 = file2.getAbsolutePath();
                LogFileTraces logFileTraces = new LogFileTraces(string, file);
                LogFileTraces logFileTraces2 = new LogFileTraces(string2, file2);
                logFileTraces.loadTraces();
                logFileTraces2.loadTraces();
                long l2 = logFileTraces.getMaxState();
                long l3 = logFileTraces2.getMaxState();
                if (l2 != l3) {
                    System.err.println("max states in" + string + " and " + string2 + " are not equal");
                }
                if ((l = xMLObject.getAttribute(CnCsToDnDsPerSiteAnalysis.BURN_IN, l2 / 10L).longValue()) < 0L || l >= l2) {
                    l = l2 / 5L;
                    System.out.println("WARNING: Burn-in larger than total number of states - using 20%");
                }
                logFileTraces.setBurnIn(l);
                logFileTraces2.setBurnIn(l);
                CnCsToDnDsPerSiteAnalysis cnCsToDnDsPerSiteAnalysis = new CnCsToDnDsPerSiteAnalysis(logFileTraces, logFileTraces2);
                cnCsToDnDsPerSiteAnalysis.setCutoff(xMLObject.getAttribute(CnCsToDnDsPerSiteAnalysis.CUTOFF, 1.0));
                cnCsToDnDsPerSiteAnalysis.setProportion(xMLObject.getAttribute(CnCsToDnDsPerSiteAnalysis.PROPORTION, 0.95));
                cnCsToDnDsPerSiteAnalysis.setSeparator(xMLObject.getAttribute(CnCsToDnDsPerSiteAnalysis.SEPARATOR_STRING, "\t"));
                cnCsToDnDsPerSiteAnalysis.setUseSample(xMLObject.getAttribute(CnCsToDnDsPerSiteAnalysis.USE_SAMPLE, false));
                cnCsToDnDsPerSiteAnalysis.setIncludeHPD(xMLObject.getAttribute(CnCsToDnDsPerSiteAnalysis.INCLUDE_HPD, true));
                cnCsToDnDsPerSiteAnalysis.setIncludeSignificanceLevel(xMLObject.getAttribute(CnCsToDnDsPerSiteAnalysis.INCLUDE_SIGNIFICANCE_LEVEL, false));
                cnCsToDnDsPerSiteAnalysis.setIncludeSignificantSymbol(xMLObject.getAttribute(CnCsToDnDsPerSiteAnalysis.INCLUDE_SIGNIFICANT_SYMBOL, true));
                cnCsToDnDsPerSiteAnalysis.setIncludeSiteClassification(xMLObject.getAttribute(CnCsToDnDsPerSiteAnalysis.INCLUDE_SITE_CLASSIFICATION, true));
                cnCsToDnDsPerSiteAnalysis.setIncludeSimulationOutcome(xMLObject.getAttribute(CnCsToDnDsPerSiteAnalysis.INCLUDE_SIMULATION_OUTCOME, false));
                if (cnCsToDnDsPerSiteAnalysis.getIncludeSimulationOutcome()) {
                    String string7 = xMLObject.getAttribute(CnCsToDnDsPerSiteAnalysis.SITE_SIMULATION, "empty");
                    if (string7.equals("empty")) {
                        System.err.println("you want simulation evaluation but do not provide a site simulation string??");
                    } else {
                        String[] stringArray = CnCsToDnDsPerSiteAnalysis.parseVariableLengthStringArray(string7);
                        cnCsToDnDsPerSiteAnalysis.setSiteSimulation(stringArray);
                    }
                }
                return cnCsToDnDsPerSiteAnalysis;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLParseException("File '" + string + "  and " + string2 + "' can not be opened for " + this.getParserName() + " element.");
            }
            catch (IOException iOException) {
                throw new XMLParseException(iOException.getMessage());
            }
            catch (TraceException traceException) {
                throw new XMLParseException(traceException.getMessage());
            }
        }

        @Override
        public String getParserDescription() {
            return "Performs a trace analysis of N and S counts.";
        }

        @Override
        public Class getReturnType() {
            return CnCsPerSiteAnalysis.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private final TraceList traceListN;
    private final TraceList traceListS;
    private final int numSites;
    private final double[][] allSmoothedCn;
    private final double[][] allSmoothedUn;
    private final double[][] allSmoothedCs;
    private final double[][] allSmoothedUs;
    private OutputFormat format;
    private int fieldWidth;
    private int firstField;
    private NumberFormatter numberFormatter;

    public CnCsToDnDsPerSiteAnalysis(TraceList traceList, TraceList traceList2) {
        this.traceListN = traceList;
        this.traceListS = traceList2;
        this.numSites = traceList.getTraceCount() / 2;
        this.format = new OutputFormat();
        this.setUseSample(false);
        double[][] dArray = new double[this.numSites][this.traceListN.getStateCount()];
        double[][] dArray2 = new double[this.numSites][this.traceListN.getStateCount()];
        double[][] dArray3 = new double[this.numSites][this.traceListS.getStateCount()];
        double[][] dArray4 = new double[this.numSites][this.traceListS.getStateCount()];
        for (int i = 0; i < this.numSites; ++i) {
            dArray[i] = CnCsToDnDsPerSiteAnalysis.listToDoubleArray(traceList.getValues(i));
            dArray2[i] = CnCsToDnDsPerSiteAnalysis.listToDoubleArray(traceList.getValues(this.numSites + i));
            dArray3[i] = CnCsToDnDsPerSiteAnalysis.listToDoubleArray(traceList2.getValues(i));
            dArray4[i] = CnCsToDnDsPerSiteAnalysis.listToDoubleArray(traceList2.getValues(this.numSites + i));
        }
        dArray = this.transpose(dArray);
        dArray2 = this.transpose(dArray2);
        dArray3 = this.transpose(dArray3);
        dArray4 = this.transpose(dArray4);
        double[][] dArray5 = new double[this.traceListN.getStateCount()][this.numSites];
        double[][] dArray6 = new double[this.traceListN.getStateCount()][this.numSites];
        double[][] dArray7 = new double[this.traceListS.getStateCount()][this.numSites];
        double[][] dArray8 = new double[this.traceListS.getStateCount()][this.numSites];
        boolean bl = true;
        for (int i = 0; i < this.traceListN.getStateCount(); ++i) {
            if (this.format.useSample) {
                dArray5[i] = EmpiricalBayesPoissonSmoother.smoothWithSample(dArray[i]);
                dArray6[i] = EmpiricalBayesPoissonSmoother.smoothWithSample(dArray2[i]);
                dArray7[i] = EmpiricalBayesPoissonSmoother.smoothWithSample(dArray3[i]);
                dArray8[i] = EmpiricalBayesPoissonSmoother.smoothWithSample(dArray4[i]);
                continue;
            }
            dArray5[i] = EmpiricalBayesPoissonSmoother.smooth(dArray[i]);
            dArray6[i] = EmpiricalBayesPoissonSmoother.smooth(dArray2[i]);
            dArray7[i] = EmpiricalBayesPoissonSmoother.smooth(dArray3[i]);
            dArray8[i] = EmpiricalBayesPoissonSmoother.smooth(dArray4[i]);
        }
        this.allSmoothedCn = this.transpose(dArray5);
        this.allSmoothedUn = this.transpose(dArray6);
        this.allSmoothedCs = this.transpose(dArray7);
        this.allSmoothedUs = this.transpose(dArray8);
        this.fieldWidth = 14;
        this.firstField = 10;
        this.numberFormatter = new NumberFormatter(6);
        this.numberFormatter.setPadding(true);
        this.numberFormatter.setFieldWidth(this.fieldWidth);
    }

    public void setIncludeMean(boolean bl) {
        this.format.includeMean = bl;
    }

    public void setIncludeHPD(boolean bl) {
        this.format.includeHPD = bl;
    }

    public void setIncludeSignificanceLevel(boolean bl) {
        this.format.includeSignificanceLevel = bl;
    }

    public void setIncludeSignificantSymbol(boolean bl) {
        this.format.includeSignificantSymbol = bl;
    }

    public void setIncludeSimulationOutcome(boolean bl) {
        this.format.includeSimulationOutcome = bl;
    }

    public boolean getIncludeSimulationOutcome() {
        return this.format.includeSimulationOutcome;
    }

    public void setProportion(double d) {
        this.format.proportion = d;
    }

    public void setSiteSimulation(String[] stringArray) {
        this.format.siteSimulation = stringArray;
    }

    public void setIncludeSiteClassification(boolean bl) {
        this.format.includeSiteClassification = bl;
    }

    public void setCutoff(double d) {
        this.format.cutoff = d;
    }

    public void setSeparator(String string) {
        this.format.separator = string;
    }

    public void setSignificanceTest(SignificanceTest significanceTest) {
        this.format.test = significanceTest;
    }

    public void setUseSample(boolean bl) {
        this.format.useSample = bl;
    }

    private String toStringSite(int n, OutputFormat outputFormat) {
        double[] dArray = CnCsToDnDsPerSiteAnalysis.getRatioArray(this.allSmoothedCn[n], this.allSmoothedUn[n]);
        double[] dArray2 = CnCsToDnDsPerSiteAnalysis.getRatioArray(this.allSmoothedCs[n], this.allSmoothedUs[n]);
        double[] dArray3 = CnCsToDnDsPerSiteAnalysis.getRatioArray(dArray, dArray2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.numberFormatter.formatToFieldWidth(Integer.toString(n + 1), this.firstField));
        double[] dArray4 = new double[2];
        double[] dArray5 = CnCsToDnDsPerSiteAnalysis.getMinMax(dArray3);
        if (outputFormat.proportion >= 1.0) {
            dArray4[0] = dArray5[0] - dArray5[0] * (outputFormat.proportion - 1.0);
            dArray4[1] = dArray5[1] + dArray5[1] * (outputFormat.proportion - 1.0);
            System.out.println("hpd = " + dArray4[0] + " - " + dArray4[1]);
        } else {
            dArray4 = CnCsToDnDsPerSiteAnalysis.getHPDInterval(outputFormat.proportion, dArray3);
        }
        if (outputFormat.includeMean) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.format(DiscreteStatistics.median(dArray3)));
        }
        if (outputFormat.includeHPD) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.format(dArray4[0]));
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.format(dArray4[1]));
        }
        if (outputFormat.includeSignificanceLevel || outputFormat.includeSignificantSymbol || outputFormat.includeSiteClassification || outputFormat.includeSimulationOutcome) {
            String string;
            boolean bl = false;
            String string2 = "0";
            if (outputFormat.test == SignificanceTest.NOT_EQUAL) {
                if (dArray4[0] < outputFormat.cutoff && dArray4[1] < outputFormat.cutoff) {
                    string = this.numberFormatter.formatToFieldWidth(">" + outputFormat.proportion, this.fieldWidth);
                    bl = true;
                    string2 = "-";
                } else if (dArray4[0] > outputFormat.cutoff && dArray4[1] > outputFormat.cutoff) {
                    string = this.numberFormatter.formatToFieldWidth(">" + outputFormat.proportion, this.fieldWidth);
                    bl = true;
                    string2 = "+";
                } else {
                    string = this.numberFormatter.formatToFieldWidth("<=" + outputFormat.proportion, this.fieldWidth);
                }
            } else {
                double d = 0.0;
                double d2 = 0.0;
                int n2 = 0;
                for (double d3 : dArray3) {
                    if (d3 < outputFormat.cutoff) {
                        if (outputFormat.test == SignificanceTest.LESS_THAN || outputFormat.test == SignificanceTest.LESS_OR_GREATER_THAN) {
                            d2 += 1.0;
                        }
                    } else if (d3 > outputFormat.cutoff && (outputFormat.test == SignificanceTest.GREATER_THAN || outputFormat.test == SignificanceTest.LESS_OR_GREATER_THAN)) {
                        d += 1.0;
                    }
                    ++n2;
                }
                d /= (double)n2;
                d2 /= (double)n2;
                if (d > outputFormat.proportion) {
                    bl = true;
                    string2 = "+";
                } else if (d2 > outputFormat.proportion) {
                    bl = true;
                    string2 = "-";
                }
                string = d > d2 ? this.numberFormatter.format(d) : this.numberFormatter.format(d2);
            }
            if (outputFormat.includeSignificanceLevel) {
                stringBuilder.append(outputFormat.separator);
                stringBuilder.append(string);
            }
            if (outputFormat.includeSiteClassification) {
                stringBuilder.append(outputFormat.separator);
                stringBuilder.append(string2);
            }
            if (outputFormat.includeSignificantSymbol) {
                stringBuilder.append(outputFormat.separator);
                if (bl) {
                    stringBuilder.append("*");
                }
            }
            if (outputFormat.includeSimulationOutcome) {
                stringBuilder.append(outputFormat.separator);
                stringBuilder.append(outputFormat.siteSimulation[n]);
                stringBuilder.append(outputFormat.separator);
                if (outputFormat.siteSimulation[n].equals("+") || outputFormat.siteSimulation[n].equals("-")) {
                    if (string2.equals(outputFormat.siteSimulation[n])) {
                        stringBuilder.append("TP");
                    } else {
                        stringBuilder.append("FN");
                    }
                } else if (string2.equals(outputFormat.siteSimulation[n])) {
                    stringBuilder.append("TN");
                } else {
                    stringBuilder.append("FP");
                }
            }
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String header(OutputFormat outputFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# Some information here\n");
        stringBuilder.append("# Please cite: " + Citable.Utils.getCitationString(this));
        stringBuilder.append(this.numberFormatter.formatToFieldWidth("Site", this.firstField));
        if (outputFormat.includeMean) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Mean", this.fieldWidth));
        }
        if (outputFormat.includeHPD) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Lower", this.fieldWidth));
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Upper", this.fieldWidth));
        }
        if (outputFormat.includeSignificanceLevel) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Level", this.fieldWidth));
        }
        if (outputFormat.includeSiteClassification) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Classification", this.fieldWidth));
        }
        if (outputFormat.includeSignificantSymbol) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Significant", this.fieldWidth));
        }
        if (outputFormat.includeSimulationOutcome) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Simulated", this.fieldWidth));
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Evaluation", this.fieldWidth));
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.header(this.format));
        for (int i = 0; i < this.numSites; ++i) {
            stringBuilder.append(this.toStringSite(i, this.format));
        }
        stringBuilder.append(this.toStringSite(0, this.format));
        return stringBuilder.toString();
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.COUNTING_PROCESSES;
    }

    @Override
    public String getDescription() {
        return "Renaissance counting";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.LEMEY_2012_RENAISSANCE);
    }

    private static double[] listToDoubleArray(List list) {
        Double[] doubleArray = list.toArray(new Double[0]);
        double[] dArray = CnCsToDnDsPerSiteAnalysis.toPrimitiveDoubleArray(doubleArray);
        return dArray;
    }

    private double[][] transpose(double[][] dArray) {
        double[][] dArray2 = new double[dArray[0].length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray2[j][i] = dArray[i][j];
            }
        }
        return dArray2;
    }

    private static double[] getFirstHalfArray(double[] dArray) {
        int n = dArray.length / 2;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    private static double[] getSecondHalfArray(double[] dArray) {
        int n = dArray.length / 2;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[n + i];
        }
        return dArray2;
    }

    private static double[] getRatioArray(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] / dArray2[i];
        }
        return dArray3;
    }

    private static double[] getMinMax(double[] dArray) {
        double[] dArray2 = new double[2];
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] > d2) {
                d2 = dArray[i];
            }
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        dArray2[0] = d;
        dArray2[1] = d2;
        return dArray2;
    }

    private static double[] getHPDInterval(double d, double[] dArray) {
        double[] dArray2 = new double[2];
        int n = dArray.length;
        int[] nArray = new int[n];
        HeapSort.sort(dArray, nArray);
        double d2 = Double.MAX_VALUE;
        int n2 = 0;
        int n3 = (int)Math.round(d * (double)n);
        for (int i = 0; i <= n - n3; ++i) {
            double d3 = dArray[nArray[i + n3 - 1]];
            double d4 = dArray[nArray[i]];
            double d5 = Math.abs(d3 - d4);
            if (!(d5 < d2)) continue;
            d2 = d5;
            n2 = i;
        }
        dArray2[0] = dArray[nArray[n2]];
        dArray2[1] = dArray[nArray[n2 + n3 - 1]];
        return dArray2;
    }

    private static double[] toPrimitiveDoubleArray(Double[] doubleArray) {
        double[] dArray = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            dArray[i] = doubleArray[i];
        }
        return dArray;
    }

    private static String[] parseVariableLengthStringArray(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() > 0) {
            String[] stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
            return stringArray;
        }
        return null;
    }

    public static enum SignificanceTest {
        GREATER_THAN("gt"),
        LESS_THAN("lt"),
        NOT_EQUAL("ne"),
        LESS_OR_GREATER_THAN("logt");

        private final String text;

        private SignificanceTest(String string2) {
            this.text = string2;
        }

        public String getText() {
            return this.text;
        }

        public static SignificanceTest parseFromString(String string) {
            for (SignificanceTest significanceTest : SignificanceTest.values()) {
                if (significanceTest.getText().compareToIgnoreCase(string) != 0) continue;
                return significanceTest;
            }
            return null;
        }
    }

    private class OutputFormat {
        boolean useSample;
        boolean includeMean;
        boolean includeHPD;
        boolean includeSignificanceLevel;
        boolean includeSignificantSymbol;
        boolean includeSiteClassification;
        boolean includeSimulationOutcome;
        String[] siteSimulation;
        double cutoff;
        double proportion;
        SignificanceTest test;
        String separator;

        OutputFormat() {
            this(false, true, true, true, true, true, false, null, 1.0, 0.95, SignificanceTest.NOT_EQUAL, "\t");
        }

        OutputFormat(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, String[] stringArray, double d, double d2, SignificanceTest significanceTest, String string) {
            this.useSample = bl;
            this.includeMean = bl2;
            this.includeHPD = bl3;
            this.includeSignificanceLevel = bl4;
            this.includeSignificantSymbol = bl5;
            this.includeSiteClassification = bl6;
            this.includeSimulationOutcome = bl7;
            this.siteSimulation = stringArray;
            this.cutoff = d;
            this.proportion = d2;
            this.test = significanceTest;
            this.separator = string;
        }
    }
}

