/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.coalescent.CoalescentIntervalProvider;
import dr.evomodel.coalescent.OldAbstractCoalescentLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.SymmTridiagMatrix;

public class OldGMRFSkyrideLikelihood
extends OldAbstractCoalescentLikelihood
implements CoalescentIntervalProvider,
Citable {
    public static final double LOG_TWO_TIMES_PI = 1.837877;
    public static final boolean TIME_AWARE_IS_ON_BY_DEFAULT = true;
    protected Parameter popSizeParameter;
    protected Parameter groupSizeParameter;
    protected Parameter precisionParameter;
    protected Parameter lambdaParameter;
    protected Parameter betaParameter;
    protected int fieldLength;
    protected double[] coalescentIntervals;
    protected double[] storedCoalescentIntervals;
    protected double[] sufficientStatistics;
    protected double[] storedSufficientStatistics;
    protected double logFieldLikelihood;
    protected double storedLogFieldLikelihood;
    protected SymmTridiagMatrix weightMatrix;
    protected SymmTridiagMatrix storedWeightMatrix;
    protected MatrixParameter dMatrix;
    protected boolean timeAwareSmoothing = true;
    protected boolean rescaleByRootHeight;
    OldAbstractCoalescentLikelihood.IntervalNodeMapping coalesentIntervalNodeMapping;
    public static Citation CITATION = new Citation(new Author[]{new Author("VN", "Minin"), new Author("EW", "Bloomquist"), new Author("MA", "Suchard")}, "Smooth skyride through a rough skyline: Bayesian coalescent-based inference of population dynamics", 2008, "Mol Biol Evol", 25, 1459, 1471, "10.1093/molbev/msn090");

    public OldGMRFSkyrideLikelihood() {
        super("gmrfSkyrideLikelihood");
    }

    public OldGMRFSkyrideLikelihood(String string) {
        super(string);
    }

    public OldGMRFSkyrideLikelihood(Tree tree, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, MatrixParameter matrixParameter, boolean bl, boolean bl2) {
        this(OldGMRFSkyrideLikelihood.wrapTree(tree), parameter, parameter2, parameter3, parameter4, parameter5, matrixParameter, bl, bl2, false);
    }

    private static List<Tree> wrapTree(Tree tree) {
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        arrayList.add(tree);
        return arrayList;
    }

    public OldGMRFSkyrideLikelihood(List<Tree> list, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, MatrixParameter matrixParameter, boolean bl, boolean bl2) {
        this(list, parameter, parameter2, parameter3, parameter4, parameter5, matrixParameter, bl, bl2, false);
    }

    public OldGMRFSkyrideLikelihood(List<Tree> list, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, MatrixParameter matrixParameter, boolean bl, boolean bl2, boolean bl3) {
        super("gmrfSkyrideLikelihood");
        this.addKeyword("skyride");
        this.popSizeParameter = parameter;
        this.groupSizeParameter = parameter2;
        this.precisionParameter = parameter3;
        this.lambdaParameter = parameter4;
        this.betaParameter = parameter5;
        this.dMatrix = matrixParameter;
        this.timeAwareSmoothing = bl;
        this.rescaleByRootHeight = bl2;
        this.addVariable(this.popSizeParameter);
        this.addVariable(this.precisionParameter);
        this.addVariable(this.lambdaParameter);
        if (this.betaParameter != null) {
            this.addVariable(this.betaParameter);
        }
        this.setTree(list);
        int n = this.getCorrectFieldLength();
        if (this.popSizeParameter.getDimension() <= 1) {
            this.popSizeParameter.setDimension(n);
        }
        this.fieldLength = this.popSizeParameter.getDimension();
        if (n != this.fieldLength) {
            throw new IllegalArgumentException("Population size parameter should have length " + n);
        }
        this.buildIntervalNodeMapping = bl3;
        this.wrapSetupIntervals();
        this.coalescentIntervals = new double[this.fieldLength];
        this.storedCoalescentIntervals = new double[this.fieldLength];
        this.sufficientStatistics = new double[this.fieldLength];
        this.storedSufficientStatistics = new double[this.fieldLength];
        this.coalesentIntervalNodeMapping = bl3 ? new OldAbstractCoalescentLikelihood.IntervalNodeMapping.Default(this.tree.getNodeCount(), this.tree) : new OldAbstractCoalescentLikelihood.IntervalNodeMapping.None();
        this.setupGMRFWeights();
        this.addStatistic(new OldAbstractCoalescentLikelihood.DeltaStatistic());
        this.initializationReport();
        if (this.groupSizeParameter != null) {
            for (int i = 0; i < this.groupSizeParameter.getDimension(); ++i) {
                this.groupSizeParameter.setParameterValue(i, 1.0);
            }
        }
    }

    protected int getCorrectFieldLength() {
        return this.tree.getExternalNodeCount() - 1;
    }

    protected void wrapSetupIntervals() {
        this.setupIntervals();
    }

    protected int setTree(List<Tree> list) {
        if (list.size() != 1) {
            throw new RuntimeException("GMRFSkyrideLikelihood only implemented for one tree");
        }
        this.tree = list.get(0);
        this.treesSet = null;
        if (this.tree instanceof TreeModel) {
            this.addModel((TreeModel)this.tree);
        }
        return 1;
    }

    public double[] getCoalescentIntervals() {
        return this.coalescentIntervals;
    }

    public void initializationReport() {
        System.out.println("Creating a GMRF smoothed skyride model:");
        System.out.println("\tPopulation sizes: " + this.popSizeParameter.getDimension());
        System.out.println("\tIf you publish results using this model, please reference: Minin, Bloomquist and Suchard (2008) Molecular Biology and Evolution, 25, 1459-1471.");
    }

    public static void checkTree(TreeModel treeModel) {
        for (int i = 0; i < treeModel.getInternalNodeCount(); ++i) {
            double d;
            NodeRef nodeRef = treeModel.getInternalNode(i);
            if (nodeRef == treeModel.getRoot()) continue;
            double d2 = treeModel.getNodeHeight(treeModel.getParent(nodeRef));
            double d3 = treeModel.getNodeHeight(treeModel.getChild(nodeRef, 0));
            double d4 = treeModel.getNodeHeight(treeModel.getChild(nodeRef, 1));
            if (d4 > (d = d3)) {
                d = d4;
            }
            double d5 = d + MathUtils.nextDouble() * (d2 - d);
            treeModel.setNodeHeight(nodeRef, d5);
        }
        treeModel.pushTreeChangedEvent();
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogCoalescentLikelihood();
            this.logFieldLikelihood = this.calculateLogFieldLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood + this.logFieldLikelihood;
    }

    protected double peakLogCoalescentLikelihood() {
        return this.logLikelihood;
    }

    protected double peakLogFieldLikelihood() {
        return this.logFieldLikelihood;
    }

    public double[] getSufficientStatistics() {
        return this.sufficientStatistics;
    }

    @Override
    public String toString() {
        return this.getId() + "(" + Double.toString(this.getLogLikelihood()) + ")";
    }

    protected void setupSufficientStatistics() {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        this.coalesentIntervalNodeMapping.initializeMaps();
        for (int i = 0; i < this.getIntervalCount(); ++i) {
            d += this.getInterval(i);
            d2 += this.getInterval(i) * (double)this.getLineageCount(i) * (double)(this.getLineageCount(i) - 1);
            int n2 = -1;
            if (this.buildIntervalNodeMapping) {
                int[] nArray = this.intervalNodeMapping.getNodeNumbersForInterval(i);
                for (int j = 0; j < nArray.length - 1; ++j) {
                    this.coalesentIntervalNodeMapping.addNode(nArray[j]);
                }
                n2 = nArray[nArray.length - 1];
            }
            if (this.getIntervalType(i) != OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT) continue;
            this.coalescentIntervals[n] = d;
            this.sufficientStatistics[n] = d2 / 2.0;
            this.coalesentIntervalNodeMapping.addNode(n2);
            ++n;
            d = 0.0;
            d2 = 0.0;
        }
        this.coalesentIntervalNodeMapping.setIntervalStartIndices(n);
    }

    @Override
    public OldAbstractCoalescentLikelihood.IntervalNodeMapping getIntervalNodeMapping() {
        return this.coalesentIntervalNodeMapping;
    }

    protected double getFieldScalar() {
        double d = this.rescaleByRootHeight ? this.tree.getNodeHeight(this.tree.getRoot()) : 1.0;
        return d;
    }

    protected void setupGMRFWeights() {
        int n;
        this.setupSufficientStatistics();
        double[] dArray = new double[this.fieldLength - 1];
        double[] dArray2 = new double[this.fieldLength];
        if (!this.timeAwareSmoothing) {
            for (n = 0; n < this.fieldLength - 1; ++n) {
                dArray[n] = -1.0;
            }
        } else {
            for (n = 0; n < this.fieldLength - 1; ++n) {
                dArray[n] = -2.0 / (this.coalescentIntervals[n] + this.coalescentIntervals[n + 1]) * this.getFieldScalar();
            }
        }
        for (n = 1; n < this.fieldLength - 1; ++n) {
            dArray2[n] = -(dArray[n] + dArray[n - 1]);
        }
        dArray2[0] = -dArray[0];
        dArray2[this.fieldLength - 1] = -dArray[this.fieldLength - 2];
        this.weightMatrix = new SymmTridiagMatrix(dArray2, dArray);
    }

    public SymmTridiagMatrix getScaledWeightMatrix(double d) {
        SymmTridiagMatrix symmTridiagMatrix = this.weightMatrix.copy();
        for (int i = 0; i < symmTridiagMatrix.numRows() - 1; ++i) {
            symmTridiagMatrix.set(i, i, symmTridiagMatrix.get(i, i) * d);
            symmTridiagMatrix.set(i + 1, i, symmTridiagMatrix.get(i + 1, i) * d);
        }
        symmTridiagMatrix.set(this.fieldLength - 1, this.fieldLength - 1, symmTridiagMatrix.get(this.fieldLength - 1, this.fieldLength - 1) * d);
        return symmTridiagMatrix;
    }

    public SymmTridiagMatrix getStoredScaledWeightMatrix(double d) {
        SymmTridiagMatrix symmTridiagMatrix = this.storedWeightMatrix.copy();
        for (int i = 0; i < symmTridiagMatrix.numRows() - 1; ++i) {
            symmTridiagMatrix.set(i, i, symmTridiagMatrix.get(i, i) * d);
            symmTridiagMatrix.set(i + 1, i, symmTridiagMatrix.get(i + 1, i) * d);
        }
        symmTridiagMatrix.set(this.fieldLength - 1, this.fieldLength - 1, symmTridiagMatrix.get(this.fieldLength - 1, this.fieldLength - 1) * d);
        return symmTridiagMatrix;
    }

    public SymmTridiagMatrix getScaledWeightMatrix(double d, double d2) {
        if (d2 == 1.0) {
            return this.getScaledWeightMatrix(d);
        }
        SymmTridiagMatrix symmTridiagMatrix = this.weightMatrix.copy();
        for (int i = 0; i < symmTridiagMatrix.numRows() - 1; ++i) {
            symmTridiagMatrix.set(i, i, d * (1.0 - d2 + d2 * symmTridiagMatrix.get(i, i)));
            symmTridiagMatrix.set(i + 1, i, symmTridiagMatrix.get(i + 1, i) * d * d2);
        }
        symmTridiagMatrix.set(this.fieldLength - 1, this.fieldLength - 1, d * (1.0 - d2 + d2 * symmTridiagMatrix.get(this.fieldLength - 1, this.fieldLength - 1)));
        return symmTridiagMatrix;
    }

    private void makeIntervalsKnown() {
        if (!this.intervalsKnown) {
            this.wrapSetupIntervals();
            this.setupGMRFWeights();
            this.intervalsKnown = true;
        }
    }

    public int getCoalescentIntervalDimension() {
        this.makeIntervalsKnown();
        return this.coalescentIntervals.length;
    }

    public double getCoalescentInterval(int n) {
        this.makeIntervalsKnown();
        return this.coalescentIntervals[n];
    }

    @Override
    public int getNumberOfCoalescentEvents() {
        return this.tree.getExternalNodeCount() - 1;
    }

    @Override
    public double getCoalescentEventsStatisticValue(int n) {
        return this.sufficientStatistics[n];
    }

    public void setupCoalescentIntervals() {
        this.setupIntervals();
        this.setupSufficientStatistics();
    }

    public double[] getCoalescentIntervalHeights() {
        this.makeIntervalsKnown();
        double[] dArray = new double[this.coalescentIntervals.length];
        dArray[0] = this.coalescentIntervals[0];
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = dArray[i - 1] + this.coalescentIntervals[i];
        }
        return dArray;
    }

    public SymmTridiagMatrix getCopyWeightMatrix() {
        return this.weightMatrix.copy();
    }

    public SymmTridiagMatrix getStoredScaledWeightMatrix(double d, double d2) {
        if (d2 == 1.0) {
            return this.getStoredScaledWeightMatrix(d);
        }
        SymmTridiagMatrix symmTridiagMatrix = this.storedWeightMatrix.copy();
        for (int i = 0; i < symmTridiagMatrix.numRows() - 1; ++i) {
            symmTridiagMatrix.set(i, i, d * (1.0 - d2 + d2 * symmTridiagMatrix.get(i, i)));
            symmTridiagMatrix.set(i + 1, i, symmTridiagMatrix.get(i + 1, i) * d * d2);
        }
        symmTridiagMatrix.set(this.fieldLength - 1, this.fieldLength - 1, d * (1.0 - d2 + d2 * symmTridiagMatrix.get(this.fieldLength - 1, this.fieldLength - 1)));
        return symmTridiagMatrix;
    }

    @Override
    protected void storeState() {
        super.storeState();
        System.arraycopy(this.coalescentIntervals, 0, this.storedCoalescentIntervals, 0, this.coalescentIntervals.length);
        System.arraycopy(this.sufficientStatistics, 0, this.storedSufficientStatistics, 0, this.sufficientStatistics.length);
        this.storedWeightMatrix = this.weightMatrix.copy();
        this.storedLogFieldLikelihood = this.logFieldLikelihood;
    }

    @Override
    protected void restoreState() {
        super.restoreState();
        double[] dArray = this.coalescentIntervals;
        this.coalescentIntervals = this.storedCoalescentIntervals;
        this.storedCoalescentIntervals = dArray;
        dArray = this.sufficientStatistics;
        this.sufficientStatistics = this.storedSufficientStatistics;
        this.storedSufficientStatistics = dArray;
        this.weightMatrix = this.storedWeightMatrix;
        this.logFieldLikelihood = this.storedLogFieldLikelihood;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
    }

    protected double calculateLogCoalescentLikelihood() {
        this.makeIntervalsKnown();
        double d = 0.0;
        double[] dArray = this.popSizeParameter.getParameterValues();
        for (int i = 0; i < this.fieldLength; ++i) {
            d += -dArray[i] - this.sufficientStatistics[i] * Math.exp(-dArray[i]);
        }
        return d;
    }

    protected double calculateLogFieldLikelihood() {
        this.makeIntervalsKnown();
        double d = 0.0;
        DenseVector denseVector = new DenseVector(this.fieldLength);
        DenseVector denseVector2 = new DenseVector(this.popSizeParameter.getParameterValues());
        SymmTridiagMatrix symmTridiagMatrix = this.getScaledWeightMatrix(this.precisionParameter.getParameterValue(0), this.lambdaParameter.getParameterValue(0));
        symmTridiagMatrix.mult(denseVector2, denseVector);
        d += 0.5 * (double)(this.fieldLength - 1) * Math.log(this.precisionParameter.getParameterValue(0)) - 0.5 * denseVector2.dot(denseVector);
        d = this.lambdaParameter.getParameterValue(0) == 1.0 ? (d -= (double)(this.fieldLength - 1) / 2.0 * 1.837877) : (d -= (double)this.fieldLength / 2.0 * 1.837877);
        return d;
    }

    public Parameter getPrecisionParameter() {
        return this.precisionParameter;
    }

    public Parameter getPopSizeParameter() {
        return this.popSizeParameter;
    }

    public Parameter getLambdaParameter() {
        return this.lambdaParameter;
    }

    public SymmTridiagMatrix getWeightMatrix() {
        return this.weightMatrix.copy();
    }

    public Parameter getBetaParameter() {
        return this.betaParameter;
    }

    public MatrixParameter getDesignMatrix() {
        return this.dMatrix;
    }

    public double calculateWeightedSSE() {
        double d = 0.0;
        double d2 = this.popSizeParameter.getParameterValue(0);
        double d3 = this.coalescentIntervals[0];
        for (int i = 1; i < this.fieldLength; ++i) {
            double d4 = this.popSizeParameter.getParameterValue(i);
            double d5 = this.coalescentIntervals[i];
            double d6 = d4 - d2;
            double d7 = (d3 + d5) / 2.0;
            d += d6 * d6 / d7;
            d2 = d4;
            d3 = d5;
        }
        return d;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Skyride coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

