/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks.meta;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.github.javacliparser.ListOption;
import com.github.javacliparser.Option;
import com.github.javacliparser.Options;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import moa.classifiers.active.ALClassifier;
import moa.core.ObjectRepository;
import moa.evaluation.preview.LearningCurve;
import moa.evaluation.preview.PreviewCollection;
import moa.evaluation.preview.PreviewCollectionLearningCurveWrapper;
import moa.gui.colorGenerator.HSVColorGenerator;
import moa.options.ClassOption;
import moa.options.ClassOptionWithListenerOption;
import moa.options.DependentOptionsUpdater;
import moa.options.EditableMultiChoiceOption;
import moa.tasks.TaskMonitor;
import moa.tasks.meta.ALMainTask;
import moa.tasks.meta.ALPrequentialEvaluationTask;
import moa.tasks.meta.ALTaskThread;

public class ALMultiParamTask
extends ALMainTask {
    private static final long serialVersionUID = 1L;
    public ClassOptionWithListenerOption prequentialEvaluationTaskOption = new ClassOptionWithListenerOption("prequentialEvaluationTask", 'e', "Prequential evaluation task to be performed for each parameter value.", ALPrequentialEvaluationTask.class, "moa.tasks.meta.ALPrequentialEvaluationTask");
    public EditableMultiChoiceOption variedParamNameOption = new EditableMultiChoiceOption("variedParamName", 'p', "Name of the parameter to be varied.", new String[]{"budget"}, new String[]{"default varied parameter name"}, 0);
    public ListOption variedParamValuesOption = new ListOption("variedParamValues", 'v', "List of parameter values to train classifiers for.", new FloatOption("value", ' ', "Parameter value.", 0.0), new FloatOption[]{new FloatOption("", ' ', "", 0.1), new FloatOption("", ' ', "", 0.2), new FloatOption("", ' ', "", 0.5)}, ',');
    private ArrayList<ALPrequentialEvaluationTask> subtasks = new ArrayList();
    private ArrayList<ALTaskThread> subtaskThreads = new ArrayList();
    private ArrayList<ALTaskThread> flattenedSubtaskThreads = new ArrayList();
    private Color[] subTaskColorCoding;
    private int partitionIdx = -1;

    @Override
    public String getPurposeString() {
        return "Individually evaluates an active learning classifier for each element of a set of parameter values using prequential evaluation (testing, then training with each example in sequence).";
    }

    public ALMultiParamTask() {
        new DependentOptionsUpdater(this.prequentialEvaluationTaskOption, this.variedParamNameOption);
    }

    public ALMultiParamTask(Color[] subTaskColorCoding) {
        this();
        this.subTaskColorCoding = subTaskColorCoding;
    }

    public void setPartitionIdx(int partitionIdx) {
        this.partitionIdx = partitionIdx;
        this.setNameSuffix("partition " + partitionIdx);
    }

    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        this.prequentialEvaluationTaskOption.getChangeListener().stateChanged(null);
        return options;
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningCurve.class;
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        File baseDumpFile;
        File ownTaskResultFile;
        super.prepareForUseImpl(monitor, repository);
        String variedParamName = this.variedParamNameOption.getValueAsCLIString();
        ALPrequentialEvaluationTask evalTask = (ALPrequentialEvaluationTask)this.prequentialEvaluationTaskOption.getPreMaterializedObject();
        ALClassifier learner = (ALClassifier)evalTask.learnerOption.getPreMaterializedObject();
        Option learnerVariedParamOption = DependentOptionsUpdater.getVariedOption(learner, variedParamName);
        Option[] paramValues = learnerVariedParamOption != null ? this.variedParamValuesOption.getList() : new Option[]{null};
        if (this.partitionIdx >= 0 && (ownTaskResultFile = this.outputFileOption.getFile()) != null) {
            this.outputFileOption.setValue(this.insertFileNameExtension(ownTaskResultFile.getAbsolutePath(), "_p" + this.partitionIdx));
        }
        String baseDumpFileName = (baseDumpFile = evalTask.dumpFileOption.getFile()) != null ? baseDumpFile.getAbsolutePath() : null;
        File baseTaskResultFile = evalTask.outputFileOption.getFile();
        String baseTaskResultName = baseTaskResultFile != null ? baseTaskResultFile.getAbsolutePath() : null;
        this.colorCoding = Color.WHITE;
        if (this.subTaskColorCoding == null) {
            this.subTaskColorCoding = new HSVColorGenerator().generateColors(paramValues.length);
        }
        for (int i = 0; i < paramValues.length; ++i) {
            ALPrequentialEvaluationTask paramValueTask = (ALPrequentialEvaluationTask)evalTask.copy();
            paramValueTask.setColorCoding(this.subTaskColorCoding[i]);
            paramValueTask.setIsLastSubtaskOnLevel(this.isLastSubtaskOnLevel, i == paramValues.length - 1);
            if (learnerVariedParamOption != null) {
                String paramValue = paramValues[i].getValueAsCLIString().trim();
                paramValueTask.setNameSuffix(paramValue);
                if (learnerVariedParamOption instanceof IntOption) {
                    int intParamValue = (int)Double.parseDouble(paramValue);
                    paramValue = Integer.toString(intParamValue);
                }
                learnerVariedParamOption.setValueViaCLIString(paramValue);
                String outputFileExtension = "";
                if (this.partitionIdx >= 0) {
                    outputFileExtension = outputFileExtension + "_p" + this.partitionIdx;
                }
                if (paramValues.length > 1) {
                    outputFileExtension = outputFileExtension + "_v" + paramValue;
                }
                if (baseDumpFileName != null) {
                    paramValueTask.dumpFileOption.setValue(this.insertFileNameExtension(baseDumpFileName, outputFileExtension));
                }
                if (baseTaskResultName != null) {
                    paramValueTask.outputFileOption.setValue(this.insertFileNameExtension(baseTaskResultName, outputFileExtension));
                }
            }
            paramValueTask.learnerOption.setValueViaCLIString(ClassOption.objectToCLIString(learner, ALClassifier.class));
            paramValueTask.prepareForUse();
            List<ALTaskThread> childSubtasks = paramValueTask.getSubtaskThreads();
            this.subtasks.add(paramValueTask);
            ALTaskThread subtaskThread = new ALTaskThread(paramValueTask);
            this.subtaskThreads.add(subtaskThread);
            this.flattenedSubtaskThreads.add(subtaskThread);
            this.flattenedSubtaskThreads.addAll(childSubtasks);
        }
        if (learnerVariedParamOption != null) {
            learnerVariedParamOption.resetToDefault();
        }
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        Option[] variedParamValueOptions = this.variedParamValuesOption.getList();
        double[] variedParamValues = new double[variedParamValueOptions.length];
        for (int i = 0; i < variedParamValueOptions.length; ++i) {
            variedParamValues[i] = Double.valueOf(variedParamValueOptions[i].getValueAsCLIString());
        }
        PreviewCollection<PreviewCollectionLearningCurveWrapper> previewCollection = new PreviewCollection<PreviewCollectionLearningCurveWrapper>("multi param entry id", "learner id", this.getClass(), this.variedParamNameOption.getValueAsCLIString(), variedParamValues);
        monitor.setCurrentActivity("Evaluating learners for parameter values...", -1.0);
        for (int i = 0; i < this.subtaskThreads.size(); ++i) {
            this.subtaskThreads.get(i).start();
        }
        int numSubtaskThreads = this.subtaskThreads.size();
        boolean allThreadsCompleted = false;
        while (!allThreadsCompleted) {
            allThreadsCompleted = true;
            int oldNumEntries = previewCollection.numEntries();
            double completionSum = 0.0;
            for (int i = 0; i < numSubtaskThreads; ++i) {
                ALTaskThread currentTaskThread = this.subtaskThreads.get(i);
                allThreadsCompleted &= currentTaskThread.isComplete();
                if (currentTaskThread.isFailed() || currentTaskThread.isCancelled()) {
                    monitor.requestCancel();
                }
                completionSum += currentTaskThread.getCurrentActivityFracComplete();
                PreviewCollectionLearningCurveWrapper latestPreview = (PreviewCollectionLearningCurveWrapper)currentTaskThread.getLatestResultPreview();
                if (latestPreview != null && latestPreview.numEntries() > 0) {
                    previewCollection.setPreview(i, latestPreview);
                    continue;
                }
                if (!currentTaskThread.isComplete()) break;
                PreviewCollectionLearningCurveWrapper finalPreview = (PreviewCollectionLearningCurveWrapper)currentTaskThread.getFinalResult();
                previewCollection.setPreview(i, finalPreview);
            }
            double completionFraction = completionSum / (double)numSubtaskThreads;
            monitor.setCurrentActivityFractionComplete(completionFraction);
            if (monitor.taskShouldAbort()) {
                return null;
            }
            if (oldNumEntries >= previewCollection.numEntries() || !monitor.resultPreviewRequested() && !this.isSubtask()) continue;
            monitor.setLatestResultPreview(previewCollection.copy());
            monitor.setCurrentActivityFractionComplete(-1.0);
        }
        return previewCollection;
    }

    @Override
    public List<ALTaskThread> getSubtaskThreads() {
        return this.flattenedSubtaskThreads;
    }

    private String insertFileNameExtension(String baseName, String fileNameExtension) {
        int fileExtIndex = baseName.lastIndexOf(46);
        String extendedName = baseName.substring(0, fileExtIndex);
        extendedName = extendedName + fileNameExtension;
        extendedName = extendedName + baseName.substring(fileExtIndex);
        return extendedName;
    }
}

