/*
 * Decompiled with CFR 0.152.
 */
package moa.recommender.rc.predictor.impl;

import java.util.ArrayList;
import java.util.List;
import moa.recommender.rc.data.RecommenderData;
import moa.recommender.rc.predictor.RatingPredictor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaselinePredictor
implements RatingPredictor {
    private static final long serialVersionUID = 8444152568941483368L;
    protected RecommenderData data;

    public BaselinePredictor(RecommenderData data) {
        this.data = data;
    }

    @Override
    public double predictRating(int userID, int itemID) {
        ArrayList<Integer> itm = new ArrayList<Integer>();
        itm.add(itemID);
        return this.predictRatings(userID, itm).get(0);
    }

    @Override
    public List<Double> predictRatings(int userID, List<Integer> itemIDS) {
        ArrayList<Double> ret = new ArrayList<Double>(itemIDS.size());
        double avg = this.data.getAvgRatingUser(userID) - this.data.getGlobalMean();
        for (int i = 0; i < itemIDS.size(); ++i) {
            int itemID = itemIDS.get(i);
            double rat = avg + this.data.getAvgRatingItem(itemID);
            rat = Math.min(Math.max(rat, this.data.getMinRating()), this.data.getMaxRating());
            ret.add(rat);
        }
        return ret;
    }

    @Override
    public RecommenderData getData() {
        return this.data;
    }

    @Override
    public void train() {
    }
}

