/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.HasNoModelException;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFVisitor;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;

public class ResourceImpl
extends EnhNode
implements Resource {
    public static final Implementation factory = new Implementation(){

        public boolean canWrap(Node n, EnhGraph eg) {
            return !n.isLiteral();
        }

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (n.isLiteral()) {
                throw new ResourceRequiredException(n);
            }
            return new ResourceImpl(n, eg);
        }
    };
    public static final Implementation rdfNodeFactory = new Implementation(){

        public boolean canWrap(Node n, EnhGraph eg) {
            return true;
        }

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (n.isURI() || n.isBlank()) {
                return new ResourceImpl(n, eg);
            }
            if (n.isLiteral()) {
                return new LiteralImpl(n, eg);
            }
            return null;
        }
    };

    public ResourceImpl(Node n, ModelCom m) {
        super(n, m);
    }

    public ResourceImpl() {
        this((ModelCom)null);
    }

    public ResourceImpl(ModelCom m) {
        this(ResourceImpl.fresh(null), m);
    }

    public ResourceImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public ResourceImpl(String uri) {
        super(ResourceImpl.fresh(uri), null);
    }

    public ResourceImpl(String nameSpace, String localName) {
        super(Node.createURI(nameSpace + localName), null);
    }

    public ResourceImpl(AnonId id) {
        this(id, null);
    }

    public ResourceImpl(AnonId id, ModelCom m) {
        this(Node.createAnon(id), m);
    }

    public ResourceImpl(String uri, ModelCom m) {
        this(ResourceImpl.fresh(uri), m);
    }

    public ResourceImpl(Resource r, ModelCom m) {
        this(r.asNode(), m);
    }

    public ResourceImpl(String nameSpace, String localName, ModelCom m) {
        this(Node.createURI(nameSpace + localName), m);
    }

    public Object visitWith(RDFVisitor rv) {
        return this.isAnon() ? rv.visitBlank(this, this.getId()) : rv.visitURI(this, this.getURI());
    }

    public RDFNode inModel(Model m) {
        return this.getModel() == m ? this : (this.isAnon() ? m.createResource(this.getId()) : (!this.asNode().isConcrete() ? ((ModelCom)m).getRDFNode(this.asNode()) : m.createResource(this.getURI())));
    }

    private static Node fresh(String uri) {
        return uri == null ? Node.createAnon() : Node.createURI(uri);
    }

    public Node getNode() {
        return this.asNode();
    }

    public AnonId getId() {
        return this.asNode().getBlankNodeId();
    }

    public String getURI() {
        return this.isAnon() ? null : this.node.getURI();
    }

    public String getNameSpace() {
        return this.isAnon() ? null : this.node.getNameSpace();
    }

    public String getLocalName() {
        return this.isAnon() ? null : this.node.getLocalName();
    }

    public boolean hasURI(String uri) {
        return this.node.hasURI(uri);
    }

    public String toString() {
        return this.asNode().toString();
    }

    protected ModelCom mustHaveModel() {
        ModelCom model = this.getModelCom();
        if (model == null) {
            throw new HasNoModelException(this);
        }
        return model;
    }

    public Statement getRequiredProperty(Property p) {
        return this.mustHaveModel().getRequiredProperty(this, p);
    }

    public Statement getProperty(Property p) {
        return this.mustHaveModel().getProperty(this, p);
    }

    public StmtIterator listProperties(Property p) {
        return this.mustHaveModel().listStatements((Resource)this, p, (RDFNode)null);
    }

    public StmtIterator listProperties() {
        return this.mustHaveModel().listStatements((Resource)this, null, (RDFNode)null);
    }

    public Resource addProperty(Property p, boolean o) {
        this.mustHaveModel().add((Resource)this, p, o);
        return this;
    }

    public Resource addProperty(Property p, long o) {
        this.mustHaveModel().add((Resource)this, p, o);
        return this;
    }

    public Resource addProperty(Property p, char o) {
        this.mustHaveModel().add((Resource)this, p, o);
        return this;
    }

    public Resource addProperty(Property p, float o) {
        this.mustHaveModel().add((Resource)this, p, o);
        return this;
    }

    public Resource addProperty(Property p, double o) {
        this.mustHaveModel().add((Resource)this, p, o);
        return this;
    }

    public Resource addProperty(Property p, String o) {
        this.mustHaveModel().add((Resource)this, p, o);
        return this;
    }

    public Resource addProperty(Property p, String o, String l) {
        this.mustHaveModel().add((Resource)this, p, o, l);
        return this;
    }

    public Resource addProperty(Property p, Object o) {
        this.mustHaveModel().add((Resource)this, p, o);
        return this;
    }

    public Resource addProperty(Property p, RDFNode o) {
        this.mustHaveModel().add((Resource)this, p, o);
        return this;
    }

    public boolean hasProperty(Property p) {
        return this.mustHaveModel().contains(this, p);
    }

    public boolean hasProperty(Property p, boolean o) {
        return this.mustHaveModel().contains((Resource)this, p, o);
    }

    public boolean hasProperty(Property p, long o) {
        return this.mustHaveModel().contains((Resource)this, p, o);
    }

    public boolean hasProperty(Property p, char o) {
        return this.mustHaveModel().contains((Resource)this, p, o);
    }

    public boolean hasProperty(Property p, float o) {
        return this.mustHaveModel().contains((Resource)this, p, o);
    }

    public boolean hasProperty(Property p, double o) {
        return this.mustHaveModel().contains((Resource)this, p, o);
    }

    public boolean hasProperty(Property p, String o) {
        return this.mustHaveModel().contains((Resource)this, p, o);
    }

    public boolean hasProperty(Property p, String o, String l) {
        return this.mustHaveModel().contains(this, p, o, l);
    }

    public boolean hasProperty(Property p, Object o) {
        return this.mustHaveModel().contains((Resource)this, p, o);
    }

    public boolean hasProperty(Property p, RDFNode o) {
        return this.mustHaveModel().contains((Resource)this, p, o);
    }

    public Resource removeProperties() {
        this.removeAll(null);
        return this;
    }

    public Resource removeAll(Property p) {
        ModelCom m = this.mustHaveModel();
        if (m instanceof InfModel) {
            Model base = ((InfModel)((Object)m)).getRawModel();
            m.remove(base.listStatements((Resource)this, p, (RDFNode)null));
        } else {
            m.remove(this.listProperties(p));
        }
        return this;
    }

    public Resource begin() {
        this.mustHaveModel().begin();
        return this;
    }

    public Resource abort() {
        this.mustHaveModel().abort();
        return this;
    }

    public Resource commit() {
        this.mustHaveModel().commit();
        return this;
    }

    public Model getModel() {
        return (Model)((Object)this.getGraph());
    }

    protected ModelCom getModelCom() {
        return (ModelCom)this.getGraph();
    }
}

