/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.Support;

class EigenRoutines {
    private static int m_maxiter = 100;
    private static double m_radix = 2.0;

    private EigenRoutines() {
    }

    static double[] householder(double[] sm, int n, boolean bVec) {
        int i;
        if (sm.length != n * n) {
            throw new MatrixException("m_err_square");
        }
        double[] ev = new double[n * 3];
        for (i = n - 1; i > 0; --i) {
            int l = i - 1;
            double h = 0.0;
            double scale = 0.0;
            if (l > 0) {
                int idxl = l * n + i;
                int k = 0;
                int idx2 = i;
                while (k < l + 1) {
                    scale += Math.abs(sm[idx2]);
                    ++k;
                    idx2 += n;
                }
                if (scale == 0.0) {
                    ev[i] = sm[idxl];
                } else {
                    int idxi;
                    int idxj;
                    int k2;
                    k = 0;
                    idx2 = i;
                    while (k < l + 1) {
                        int n2 = idx2;
                        sm[n2] = sm[n2] / scale;
                        h += sm[idx2] * sm[idx2];
                        ++k;
                        idx2 += n;
                    }
                    double f = sm[idxl];
                    double hsqrt = Math.sqrt(h);
                    double g = f >= 0.0 ? -hsqrt : hsqrt;
                    ev[i] = scale * g;
                    h -= f * g;
                    sm[idxl] = f - g;
                    f = 0.0;
                    int j = 0;
                    int idx3 = i * n;
                    int idx5 = i;
                    int idx4 = j * n + i;
                    while (j < l + 1) {
                        if (bVec) {
                            sm[idx3] = sm[idx4] / h;
                        }
                        g = 0.0;
                        k2 = 0;
                        idxj = k2 * n + j;
                        idxi = k2 * n + i;
                        while (k2 < j + 1) {
                            g += sm[idxj] * sm[idxi];
                            ++k2;
                            idxj += n;
                            idxi += n;
                        }
                        k2 = j + 1;
                        idxj = j * n + k2;
                        idxi = k2 * n + i;
                        while (k2 < l + 1) {
                            g += sm[idxj] * sm[idxi];
                            ++k2;
                            ++idxj;
                            idxi += n;
                        }
                        ev[j] = g / h;
                        f += ev[j] * sm[idx5];
                        ++j;
                        ++idx3;
                        idx4 += n;
                        idx5 += n;
                    }
                    double hh = f / (h + h);
                    int j2 = 0;
                    int idx32 = i;
                    while (j2 < l + 1) {
                        f = sm[idx32];
                        ev[j2] = g = ev[j2] - hh * f;
                        k2 = 0;
                        idxj = j2;
                        idxi = i;
                        while (k2 < j2 + 1) {
                            int n3 = idxj;
                            sm[n3] = sm[n3] - (f * ev[k2] + g * sm[idxi]);
                            ++k2;
                            idxj += n;
                            idxi += n;
                        }
                        ++j2;
                        idx32 += n;
                    }
                }
            } else {
                ev[i] = sm[i];
            }
            ev[n + i] = h;
        }
        ev[0] = 0.0;
        ev[n] = 0.0;
        i = 0;
        int idxii = 0;
        int idxi = 0;
        while (i < n) {
            int j;
            int l = i;
            if (bVec && ev[n + i] != 0.0) {
                int idxj = 0;
                for (j = 0; j < l; ++j) {
                    double g = 0.0;
                    int k = 0;
                    int idxji = i;
                    int idxk = idxj;
                    while (k < l) {
                        g += sm[idxji] * sm[idxk];
                        ++k;
                        idxji += n;
                        ++idxk;
                    }
                    k = 0;
                    int idxk2 = idxj;
                    int idxki = i * n;
                    while (k < l) {
                        int n4 = idxk2++;
                        sm[n4] = sm[n4] - g * sm[idxki];
                        ++k;
                        ++idxki;
                    }
                    idxj += n;
                }
            }
            ev[n + i] = sm[idxii];
            if (bVec) {
                sm[idxii] = 1.0;
                int idxij = i;
                for (j = 0; j < l; ++j) {
                    sm[idxi + j] = 0.0;
                    sm[idxij] = 0.0;
                    idxij += n;
                }
            }
            idxii += n + 1;
            ++i;
            idxi += n;
        }
        i = 1;
        int idxm = 2 * n;
        while (i < n) {
            ev[idxm] = ev[i];
            ++i;
            ++idxm;
        }
        return ev;
    }

    static void hessenberg(double[] std, int n) {
        if (std.length != n * n) {
            throw new MatrixException("m_err_square");
        }
        int m = 1;
        int idx = 0;
        while (m < n - 1) {
            double x = 0.0;
            int i = m;
            int j = m;
            int idx2 = idx + j;
            while (j < n) {
                if (Math.abs(std[idx2]) > Math.abs(x)) {
                    x = std[idx2];
                    i = j;
                }
                ++j;
                ++idx2;
            }
            int idxi = i * n;
            int idxm = m * n;
            if (i != m) {
                int j2 = m - 1;
                int idx22 = j2 * n;
                while (j2 < n) {
                    double tmp = std[idx22 + i];
                    std[idx22 + i] = std[idx22 + m];
                    std[idx22 + m] = tmp;
                    ++j2;
                    idx22 += n;
                }
                for (j2 = 0; j2 < n; ++j2) {
                    double tmp = std[idxi + j2];
                    std[idxi + j2] = std[idxm + j2];
                    std[idxm + j2] = tmp;
                }
            }
            if (x != 0.0) {
                for (int l = m + 1; l < n; ++l) {
                    double y = std[idx + l];
                    if (y == 0.0) continue;
                    std[idx + l] = y /= x;
                    int j3 = m;
                    int idxj = m * n;
                    while (j3 < n) {
                        int n2 = idxj + l;
                        std[n2] = std[n2] - y * std[idxj + m];
                        ++j3;
                        idxj += n;
                    }
                    j3 = 0;
                    int idxl = l * n;
                    while (j3 < n) {
                        int n3 = idxm + j3;
                        std[n3] = std[n3] + y * std[idxl];
                        ++j3;
                        ++idxl;
                    }
                }
            }
            ++m;
            idx += n;
        }
        int i = 0;
        idx = 0;
        while (i < n - 2) {
            int j = i + 2;
            int idx2 = idx + j;
            while (j < n) {
                std[idx2] = 0.0;
                ++j;
                ++idx2;
            }
            ++i;
            idx += n;
        }
    }

    static void triQL(double[] ev, int n, double[] zz, boolean bVec) {
        for (int i = 1; i < n; ++i) {
            ev[i - 1] = ev[i];
        }
        ev[n - 1] = 0.0;
        int m = 0;
        int l = 0;
        int idxld = n;
        int idxle = 0;
        while (l < n) {
            int iter = 0;
            do {
                int i;
                int mm = l + n;
                int idxd = n + m;
                int idxe = m = l;
                while (m < n - 1) {
                    double dd = Math.abs(ev[idxd]) + Math.abs(ev[idxd + 1]);
                    if (Math.abs(ev[idxe]) + dd == dd) break;
                    ++m;
                    ++idxd;
                    ++idxe;
                    ++mm;
                }
                if (m == l) continue;
                if (iter++ == m_maxiter) {
                    throw new MatrixException("eig_failed");
                }
                double g = (ev[idxld + 1] - ev[idxld]) / (2.0 * ev[idxle]);
                double r = Support.pythagoras(g, 1.0);
                g = ev[m + n] - ev[idxld] + ev[idxle] / (g + Support.sign(r, g));
                double s = 1.0;
                double c = 1.0;
                double p = 0.0;
                for (i = m - 1; i >= l; --i) {
                    double f = s * ev[i];
                    double b = c * ev[i];
                    ev[i + 1] = r = Support.pythagoras(f, g);
                    if (r == 0.0) {
                        int n2 = n + i + 1;
                        ev[n2] = ev[n2] - p;
                        ev[m] = 0.0;
                        break;
                    }
                    s = f / r;
                    c = g / r;
                    g = ev[n + i + 1] - p;
                    r = (ev[n + i] - g) * s + 2.0 * c * b;
                    p = s * r;
                    ev[n + i + 1] = g + p;
                    g = c * r - b;
                    if (!bVec) continue;
                    int k = 0;
                    int idxz = i * n;
                    int idxzz = idxz + n;
                    while (k < n) {
                        f = zz[idxzz];
                        zz[idxzz] = s * zz[idxz] + c * f;
                        zz[idxz] = c * zz[idxz] - s * f;
                        ++k;
                        ++idxz;
                        ++idxzz;
                    }
                }
                if (r == 0.0 && i >= l) continue;
                int n3 = idxld;
                ev[n3] = ev[n3] - p;
                ev[idxle] = g;
                ev[m] = 0.0;
            } while (m != l);
            ++l;
            ++idxld;
            ++idxle;
        }
    }

    static Complex[] hessenbergQR(double[] std, int n) {
        if (std.length != n * n) {
            throw new MatrixException("m_err_square");
        }
        double anorm = 0.0;
        double z = 0.0;
        double y = 0.0;
        double x = 0.0;
        double w = 0.0;
        double v = 0.0;
        double u = 0.0;
        double t = 0.0;
        double s = 0.0;
        double r = 0.0;
        double p = 0.0;
        double q = 0.0;
        Complex[] eigenval = new Complex[n];
        for (int i = 0; i < n; ++i) {
            int j = Math.max(i - 1, 0);
            int idx = j * n + i;
            while (j < n) {
                anorm += Math.abs(std[j * n + i]);
                ++j;
                idx += n;
            }
        }
        int nn = n - 1;
        t = 0.0;
        while (nn >= 0) {
            int its = 0;
            int l = 0;
            do {
                for (l = nn; l > 0; --l) {
                    s = Math.abs(std[(l - 1) * n + l - 1]) + Math.abs(std[l * n + l]);
                    if (s == 0.0) {
                        s = anorm;
                    }
                    if (Math.abs(std[(l - 1) * n + l]) + s != s) continue;
                    std[(l - 1) * n + l] = 0.0;
                    break;
                }
                x = std[nn * n + nn];
                if (l == nn) {
                    eigenval[nn--] = Complex.cart(x + t, 0.0);
                    continue;
                }
                y = std[(nn - 1) * n + (nn - 1)];
                w = std[(nn - 1) * n + nn] * std[nn * n + (nn - 1)];
                if (l == nn - 1) {
                    p = 0.5 * (y - x);
                    q = p * p + w;
                    z = Math.sqrt(Math.abs(q));
                    x += t;
                    if (q >= 0.0) {
                        z = p + Support.sign(z, p);
                        eigenval[nn - 1] = Complex.cart(x + z);
                        eigenval[nn] = eigenval[nn - 1];
                        if (z != 0.0) {
                            eigenval[nn] = Complex.cart(x - w / z);
                        }
                    } else {
                        eigenval[nn] = Complex.cart(x + p, z);
                        eigenval[nn - 1] = eigenval[nn].conj();
                    }
                    nn -= 2;
                    continue;
                }
                if (its == m_maxiter) {
                    throw new MatrixException("eig_failed");
                }
                if (its == 10 || its == 20) {
                    t += x;
                    for (int i = 0; i < nn + 1; ++i) {
                        int n2 = i * n + i;
                        std[n2] = std[n2] - x;
                    }
                    s = Math.abs(std[(nn - 1) * n + nn]) + Math.abs(std[(nn - 2) * n + nn - 1]);
                    x = y = 0.75 * s;
                    w = -0.4375 * s * s;
                }
                ++its;
                int m = 0;
                for (m = nn - 2; m >= l; --m) {
                    z = std[m * n + m];
                    r = x - z;
                    s = y - z;
                    p = (r * s - w) / std[m * n + m + 1] + std[(m + 1) * n + m];
                    q = std[(m + 1) * n + m + 1] - z - r - s;
                    r = std[(m + 1) * n + m + 2];
                    s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (m == l || (u = Math.abs(std[(m - 1) * n + m]) * (Math.abs(q /= s) + Math.abs(r /= s))) + (v = Math.abs(p /= s) * (Math.abs(std[(m - 1) * n + m - 1]) + Math.abs(z) + Math.abs(std[(m + 1) * n + m + 1]))) == v) break;
                }
                for (int i = m; i < nn - 1; ++i) {
                    std[i * n + i + 2] = 0.0;
                    if (i == m) continue;
                    std[(i - 1) * n + i + 2] = 0.0;
                }
                for (int k = m; k < nn; ++k) {
                    if (k != m) {
                        p = std[(k - 1) * n + k];
                        q = std[(k - 1) * n + k + 1];
                        r = 0.0;
                        if (k + 1 != nn) {
                            r = std[(k - 1) * n + k + 2];
                        }
                        if ((x = Math.abs(p) + Math.abs(q) + Math.abs(r)) != 0.0) {
                            p /= x;
                            q /= x;
                            r /= x;
                        }
                    }
                    if ((s = Support.sign(Math.sqrt(p * p + q * q + r * r), p)) == 0.0) continue;
                    if (k == m) {
                        if (m != l) {
                            int n3 = (k - 1) * n + k;
                            std[n3] = std[n3] * -1.0;
                        }
                    } else {
                        std[(k - 1) * n + k] = -s * x;
                    }
                    x = (p += s) / s;
                    y = q / s;
                    z = r / s;
                    q /= p;
                    r /= p;
                    for (int j = k; j < nn + 1; ++j) {
                        p = std[j * n + k] + q * std[j * n + k + 1];
                        if (k + 1 != nn) {
                            int n4 = j * n + k + 2;
                            std[n4] = std[n4] - (p += r * std[j * n + k + 2]) * z;
                        }
                        int n5 = j * n + k + 1;
                        std[n5] = std[n5] - p * y;
                        int n6 = j * n + k;
                        std[n6] = std[n6] - p * x;
                    }
                    int mmin = nn < k + 3 ? nn : k + 3;
                    for (int i = l; i < mmin + 1; ++i) {
                        p = x * std[k * n + i] + y * std[(k + 1) * n + i];
                        if (k != nn - 1) {
                            int n7 = (k + 2) * n + i;
                            std[n7] = std[n7] - (p += z * std[(k + 2) * n + i]) * r;
                        }
                        int n8 = (k + 1) * n + i;
                        std[n8] = std[n8] - p * q;
                        int n9 = k * n + i;
                        std[n9] = std[n9] - p;
                    }
                }
            } while (l + 1 < nn);
        }
        return eigenval;
    }

    static void balance(double[] std, int n) {
        if (std.length != n * n) {
            throw new MatrixException("m_err_square");
        }
        double sqrd = m_radix * m_radix;
        boolean last = false;
        while (!last) {
            last = true;
            int i = 0;
            int idxci = 0;
            while (i < n) {
                double r = 0.0;
                double c = 0.0;
                int j = 0;
                int idxji = idxci;
                int idxij = i;
                while (j < n) {
                    if (j != i) {
                        c += Math.abs(std[idxji]);
                        r += Math.abs(std[idxij]);
                    }
                    ++j;
                    ++idxji;
                    idxij += n;
                }
                if (c != 0.0 && r != 0.0) {
                    double g = r / m_radix;
                    double f = 1.0;
                    double s = c + r;
                    while (c < g) {
                        f *= m_radix;
                        c *= sqrd;
                    }
                    g = r * m_radix;
                    while (c > g) {
                        f /= m_radix;
                        c /= sqrd;
                    }
                    if ((c + r) / f < 0.95 * s) {
                        last = false;
                        g = 1.0 / f;
                        int j2 = 0;
                        int idx = i;
                        while (j2 < n) {
                            int n2 = idx;
                            std[n2] = std[n2] * g;
                            ++j2;
                            idx += n;
                        }
                        idx = idxci;
                        for (j2 = 0; j2 < n; ++j2) {
                            int n3 = idx++;
                            std[n3] = std[n3] * f;
                        }
                    }
                }
                ++i;
                idxci += n;
            }
        }
    }

    static int getMaxIter() {
        return m_maxiter;
    }

    static void setMaxIter(int value) {
        m_maxiter = value;
    }

    static double getRadix() {
        return m_radix;
    }

    static void setRadix(double value) {
        m_radix = value;
    }
}

