/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.diagnostics;

import ec.satoolkit.diagnostics.Ranking;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.dstats.Chi2;
import ec.tstoolkit.dstats.F;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.stats.StatisticalTest;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;

public class FriedmanTest
extends StatisticalTest {
    private int m_n;
    private int m_k;
    private double m_sst;
    private double m_sse;
    private double m_t;

    public FriedmanTest(TsData ts) {
        DataBlock x = TsDataBlock.all((TsData)ts).data;
        this.process(x, ts.getFrequency().intValue(), false);
    }

    public FriedmanTest(TsData ts, boolean f) {
        DataBlock x = TsDataBlock.all((TsData)ts).data;
        this.process(x, ts.getFrequency().intValue(), f);
    }

    public int getK() {
        return this.m_k;
    }

    public int getN() {
        return this.m_n;
    }

    public double getSse() {
        return this.m_sse;
    }

    public double getSst() {
        return this.m_sst;
    }

    public double getT() {
        return this.m_t;
    }

    private void process(DataBlock all, int freq, boolean f) {
        int nall = all.getLength();
        this.m_k = freq;
        this.m_n = nall / freq;
        DataBlock x = all.drop(nall - this.m_n * this.m_k, 0);
        DataBlock y = x.range(0, freq);
        Matrix R = new Matrix(this.m_n, this.m_k);
        int row = 0;
        for (int i = 0; i < this.m_n; ++i) {
            Ranking.sort(y, R.row(row++));
            y.move(freq);
        }
        double rmean = R.sum() / (double)(this.m_n * this.m_k);
        this.m_sst = 0.0;
        DataBlockIterator cols = R.columns();
        DataBlock col = cols.getData();
        do {
            double tmp = col.sum() / (double)this.m_n - rmean;
            this.m_sst += tmp * tmp;
        } while (cols.next());
        this.m_sst *= (double)this.m_n;
        R.sub(rmean);
        this.m_sse = R.ssq() / (double)(this.m_n * (this.m_k - 1));
        this.m_type = TestType.Upper;
        this.m_t = this.m_sst / this.m_sse;
        int nk = this.m_n * (this.m_k - 1);
        if (f && this.m_t < (double)nk) {
            F ftest = new F();
            ftest.setDFNum(this.m_k - 1);
            ftest.setDFDenom((this.m_k - 1) * (this.m_n - 1));
            this.m_dist = ftest;
            this.m_val = (double)(this.m_n - 1) * this.m_t / ((double)nk - this.m_t);
        } else {
            Chi2 chi2 = new Chi2();
            chi2.setDegreesofFreedom(this.m_k - 1);
            this.m_dist = chi2;
            this.m_val = this.m_t;
        }
    }
}

