/*
 * Decompiled with CFR 0.152.
 */
package core.stats.scorer;

import core.model.DecomposableModel;
import core.model.GraphAction;
import core.model.ScoredGraphAction;
import core.stats.EntropyComputer;
import core.stats.scorer.GraphActionScorer;

public class GraphActionScorerBIC
extends GraphActionScorer {
    int nbInstances;
    double lognbInstances;
    EntropyComputer entropyComputer;
    int maxK;

    public GraphActionScorerBIC(EntropyComputer entropyComputer, int maxK) {
        this.entropyComputer = entropyComputer;
        this.nbInstances = entropyComputer.getNbInstances();
        this.lognbInstances = Math.log(this.nbInstances);
        this.maxK = maxK;
    }

    @Override
    public ScoredGraphAction scoreEdge(DecomposableModel model, GraphAction action) {
        Double score;
        int treeWidthIfAdding = model.treeWidthIfAdding(action.getV1(), action.getV2());
        if (treeWidthIfAdding > this.maxK) {
            score = Double.POSITIVE_INFINITY;
        } else {
            double df = model.nbParametersDiffIfAdding(action.getV1(), action.getV2());
            double dentropy = model.entropyDiffIfAdding(action.getV1(), action.getV2(), this.entropyComputer);
            double dbic = (double)(-2 * this.nbInstances) * dentropy + df * this.lognbInstances;
            score = dbic;
        }
        ScoredGraphAction scoredAction = new ScoredGraphAction(action.getType(), action.getV1(), action.getV2(), score);
        return scoredAction;
    }
}

