/*
 * Decompiled with CFR 0.152.
 */
package org.I0Itec.zkclient;

import java.io.Serializable;
import java.util.List;
import org.I0Itec.zkclient.ExceptionUtil;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;

public class DistributedQueue<T extends Serializable> {
    private ZkClient _zkClient;
    private String _root;
    private static final String ELEMENT_NAME = "element";

    public DistributedQueue(ZkClient zkClient, String root2) {
        this._zkClient = zkClient;
        this._root = root2;
    }

    public boolean offer(T element) {
        try {
            this._zkClient.createPersistentSequential(this._root + "/" + ELEMENT_NAME + "-", element);
        }
        catch (Exception e) {
            throw ExceptionUtil.convertToRuntimeException(e);
        }
        return true;
    }

    /*
     * Loose catch block
     */
    public T poll() {
        while (true) {
            Element<T> element;
            if ((element = this.getFirstElement()) == null) {
                return null;
            }
            try {
                this._zkClient.delete(element.getName());
                return (T)((Serializable)element.getData());
            }
            catch (ZkNoNodeException e) {
                continue;
            }
            break;
        }
        catch (Exception e) {
            throw ExceptionUtil.convertToRuntimeException(e);
        }
    }

    private String getSmallestElement(List<String> list2) {
        String smallestElement = list2.get(0);
        for (String element : list2) {
            if (element.compareTo(smallestElement) >= 0) continue;
            smallestElement = element;
        }
        return smallestElement;
    }

    public boolean isEmpty() {
        return this._zkClient.getChildren(this._root).size() == 0;
    }

    private Element<T> getFirstElement() {
        try {
            while (true) {
                List<String> list2;
                if ((list2 = this._zkClient.getChildren(this._root)).size() == 0) {
                    return null;
                }
                String elementName = this.getSmallestElement(list2);
                try {
                    return new Element<Serializable>(this._root + "/" + elementName, (Serializable)this._zkClient.readData(this._root + "/" + elementName));
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.convertToRuntimeException(e);
        }
    }

    public T peek() {
        Element<T> element = this.getFirstElement();
        if (element == null) {
            return null;
        }
        return (T)((Serializable)element.getData());
    }

    private static class Element<T> {
        private String _name;
        private T _data;

        public Element(String name, T data2) {
            this._name = name;
            this._data = data2;
        }

        public String getName() {
            return this._name;
        }

        public T getData() {
            return this._data;
        }
    }
}

