/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.BoxChartBuilder;
import org.knowm.xchart.BoxSeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.AxisPair;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Legend_Marker;
import org.knowm.xchart.internal.chartpart.Plot_Box;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyle;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyleCycler;
import org.knowm.xchart.style.BoxStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.theme.Theme;

public class BoxChart
extends Chart<BoxStyler, BoxSeries> {
    private final List<String> xData = new ArrayList<String>();

    protected BoxChart(int width, int height) {
        super(width, height, new BoxStyler());
        this.axisPair = new AxisPair<BoxStyler, BoxSeries>(this);
        this.plot = new Plot_Box<BoxStyler, BoxSeries>(this);
        this.legend = new Legend_Marker<BoxStyler, BoxSeries>(this);
    }

    public BoxChart(int width, int height, Theme theme) {
        this(width, height);
        ((BoxStyler)this.styler).setTheme(theme);
        ((BoxStyler)this.styler).setLegendVisible(false);
    }

    public BoxChart(int width, int height, Styler.ChartTheme chartTheme) {
        this(width, height, chartTheme.newInstance(chartTheme));
    }

    public BoxChart(BoxChartBuilder chartBuilder) {
        this(chartBuilder.width, chartBuilder.height, chartBuilder.chartTheme);
        this.setTitle(chartBuilder.title);
        this.setXAxisTitle(chartBuilder.xAxisTitle);
        this.setYAxisTitle(chartBuilder.yAxisTitle);
    }

    public BoxSeries addSeries(String seriesName, int[] yData) {
        return this.addSeries(seriesName, Utils.getNumberListFromIntArray(yData));
    }

    public BoxSeries addSeries(String seriesName, double[] yData) {
        return this.addSeries(seriesName, Utils.getNumberListFromDoubleArray(yData));
    }

    public BoxSeries addSeries(String seriesName, List<? extends Number> yData) {
        this.sanityCheck(seriesName, yData);
        this.xData.add(seriesName);
        BoxSeries series = new BoxSeries(seriesName, this.xData, yData, null, Series.DataType.String);
        this.seriesMap.put(seriesName, series);
        return series;
    }

    private void sanityCheck(String seriesName, List<? extends Number> yData) {
        if (this.seriesMap.containsKey(seriesName)) {
            throw new IllegalArgumentException("Series name > " + seriesName + " < has already been used. Use unique names for each series!!!");
        }
        this.sanityCheckYData(yData);
    }

    private void sanityCheckYData(List<? extends Number> yData) {
        if (yData == null) {
            throw new IllegalArgumentException("Y-Axis data connot be null !!!");
        }
        if (yData.size() == 0) {
            throw new IllegalArgumentException("Y-Axis data connot be empyt !!!");
        }
        if (yData.contains(null)) {
            throw new IllegalArgumentException("Y-Axis data cannot contain null !!!");
        }
    }

    public BoxSeries updateBoxSeries(String seriesName, int[] newYData) {
        return this.updateBoxSeries(seriesName, Utils.getNumberListFromIntArray(newYData));
    }

    public BoxSeries updateBoxSeries(String seriesName, double[] newYData) {
        return this.updateBoxSeries(seriesName, Utils.getNumberListFromDoubleArray(newYData));
    }

    public BoxSeries updateBoxSeries(String seriesName, List<? extends Number> newYData) {
        Map seriesMap = this.getSeriesMap();
        BoxSeries series = (BoxSeries)seriesMap.get(seriesName);
        if (series == null) {
            throw new IllegalArgumentException("Series name > " + seriesName + " < not found !!!");
        }
        this.sanityCheckYData(newYData);
        series.replaceData(newYData);
        return series;
    }

    private void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((BoxStyler)this.getStyler()).getSeriesColors(), ((BoxStyler)this.getStyler()).getSeriesMarkers(), ((BoxStyler)this.getStyler()).getSeriesLines());
        SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
        for (BoxSeries series : this.getSeriesMap().values()) {
            if (series.getLineStyle() == null) {
                series.setLineStyle(seriesColorMarkerLineStyle.getStroke());
            }
            if (series.getLineColor() == null) {
                series.setLineColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getFillColor() == null) {
                series.setFillColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getMarker() == null) {
                series.setMarker(seriesColorMarkerLineStyle.getMarker());
            }
            if (series.getMarkerColor() != null) continue;
            series.setMarkerColor(seriesColorMarkerLineStyle.getColor());
        }
    }

    @Override
    public void paint(Graphics2D g2, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.setSeriesStyles();
        this.paintBackground(g2);
        this.axisPair.paint(g2);
        this.plot.paint(g2);
        this.chartTitle.paint(g2);
        this.annotations.forEach(x -> x.paint(g2));
    }
}

