/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.tiledimage;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import org.jaitools.CollectionFactory;
import org.jaitools.tilecache.DiskMemTileCache;
import org.jaitools.tiledimage.DiskMemImageGraphics;
import org.jaitools.tiledimage.PixelOutsideImageException;

public class DiskMemImage
extends PlanarImage
implements WritableRenderedImage {
    public static final long DEFAULT_COMMON_CACHE_SIZE = 0x10000000L;
    private static DiskMemTileCache commonCache = null;
    protected DiskMemTileCache tileCache;
    protected Rectangle tileGrid = new Rectangle(this.getMinTileX(), this.getMinTileY(), this.getMaxTileX() - this.getMinTileX() + 1, this.getMaxTileY() - this.getMinTileY() + 1);
    protected int[][] numWriters;
    protected int numTilesInUse;
    protected long tileMemorySize;
    protected Set<TileObserver> tileObservers;

    public static DiskMemTileCache getCommonTileCache() {
        if (commonCache == null) {
            commonCache = DiskMemImage.createNewCache();
        }
        return commonCache;
    }

    public static void setCommonTileCache(DiskMemTileCache newCache) {
        if (newCache != null && commonCache == null) {
            commonCache = newCache;
        }
    }

    private static DiskMemTileCache createNewCache() {
        HashMap<String, Object> cacheParams = new HashMap<String, Object>();
        cacheParams.put("memcapacity", 0x10000000L);
        cacheParams.put("diskcache", Boolean.FALSE);
        DiskMemTileCache cache = new DiskMemTileCache(cacheParams);
        cache.setDiagnostics(false);
        return cache;
    }

    public DiskMemImage(int width, int height, SampleModel tileSampleModel) {
        this(0, 0, width, height, 0, 0, tileSampleModel, null);
    }

    public DiskMemImage(int width, int height, SampleModel tileSampleModel, ColorModel colorModel) {
        this(0, 0, width, height, 0, 0, tileSampleModel, colorModel);
    }

    public DiskMemImage(int minX, int minY, int width, int height, SampleModel tileSampleModel) {
        this(minX, minY, width, height, 0, 0, tileSampleModel, null);
    }

    public DiskMemImage(int minX, int minY, int width, int height, int tileGridXOffset, int tileGridYOffset, SampleModel tileSampleModel) {
        this(minX, minY, width, height, tileGridXOffset, tileGridYOffset, tileSampleModel, null);
    }

    public DiskMemImage(int minX, int minY, int width, int height, int tileGridXOffset, int tileGridYOffset, SampleModel tileSampleModel, ColorModel colorModel) {
        super(new ImageLayout(minX, minY, width, height, tileGridXOffset, tileGridYOffset, tileSampleModel.getWidth(), tileSampleModel.getHeight(), tileSampleModel, colorModel), null, null);
        this.numWriters = new int[this.tileGrid.width][this.tileGrid.height];
        this.numTilesInUse = 0;
        DataBuffer db = tileSampleModel.createDataBuffer();
        this.tileMemorySize = (long)DataBuffer.getDataTypeSize(db.getDataType()) / 8L * (long)db.getSize() * (long)db.getNumBanks();
        this.tileObservers = CollectionFactory.set();
        this.tileCache = null;
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        Raster r = null;
        if (this.tileGrid.contains(tileX, tileY) && (r = this.getTileCache().getTile(this, tileX, tileY)) == null) {
            r = this.createTile(tileX, tileY);
            this.getTileCache().add(this, tileX, tileY, r);
        }
        return r;
    }

    @Override
    public void addTileObserver(TileObserver to) {
        this.tileObservers.add(to);
    }

    @Override
    public void removeTileObserver(TileObserver to) {
        this.tileObservers.remove(to);
    }

    @Override
    public WritableRaster getWritableTile(int tileX, int tileY) {
        WritableRaster r = null;
        if (this.tileGrid.contains(tileX, tileY)) {
            int[] nArray = this.numWriters[tileX - this.tileGrid.x];
            int n = tileY - this.tileGrid.y;
            nArray[n] = nArray[n] + 1;
            if (this.numWriters[tileX - this.tileGrid.x][tileY - this.tileGrid.y] == 1) {
                ++this.numTilesInUse;
            }
            if ((r = (WritableRaster)this.getTileCache().getTile(this, tileX, tileY)) == null) {
                r = this.createTile(tileX, tileY);
                this.getTileCache().add(this, tileX, tileY, r);
            }
            for (TileObserver obs : this.tileObservers) {
                obs.tileUpdate(this, tileX, tileY, true);
            }
        }
        return r;
    }

    @Override
    public void releaseWritableTile(int tileX, int tileY) {
        if (this.tileGrid.contains(tileX, tileY)) {
            int[] nArray = this.numWriters[tileX - this.tileGrid.x];
            int n = tileY - this.tileGrid.y;
            nArray[n] = nArray[n] - 1;
            if (this.numWriters[tileX - this.tileGrid.x][tileY - this.tileGrid.y] < 0) {
                Logger.getLogger(DiskMemImage.class.getName()).log(Level.SEVERE, String.format("Tile %d,%d released more times than it has been checked out", tileX, tileY));
            } else if (this.numWriters[tileX - this.tileGrid.x][tileY - this.tileGrid.y] == 0) {
                --this.numTilesInUse;
            }
            try {
                this.getTileCache().setTileChanged(this, tileX, tileY);
            }
            catch (Exception ex) {
                Logger.getLogger(DiskMemImage.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (TileObserver obs : this.tileObservers) {
                obs.tileUpdate(this, tileX, tileY, false);
            }
        }
    }

    @Override
    public boolean isTileWritable(int tileX, int tileY) {
        return this.numWriters[tileX - this.tileGrid.x][tileY - this.tileGrid.y] > 0;
    }

    @Override
    public Point[] getWritableTileIndices() {
        Point[] indices = null;
        if (this.numTilesInUse > 0) {
            indices = new Point[this.numTilesInUse];
            int k = 0;
            int y = this.tileGrid.y;
            for (int ny = 0; ny < this.tileGrid.height; ++ny) {
                int x = this.tileGrid.x;
                for (int nx = 0; nx < this.tileGrid.width; ++nx) {
                    if (this.numWriters[nx][ny] > 0) {
                        indices[k++] = new Point(x, y);
                    }
                    ++x;
                }
                ++y;
            }
        }
        return indices;
    }

    @Override
    public boolean hasTileWriters() {
        return this.numTilesInUse > 0;
    }

    public int getSample(int x, int y, int b2) throws PixelOutsideImageException {
        int tileY;
        int tileX = this.XToTileX(x);
        Raster t = this.getTile(tileX, tileY = this.YToTileY(y));
        if (t == null) {
            throw new PixelOutsideImageException(x, y, b2);
        }
        return t.getSample(x, y, b2);
    }

    public float getSampleFloat(int x, int y, int b2) throws PixelOutsideImageException {
        int tileY;
        int tileX = this.XToTileX(x);
        Raster t = this.getTile(tileX, tileY = this.YToTileY(y));
        if (t == null) {
            throw new PixelOutsideImageException(x, y, b2);
        }
        return t.getSampleFloat(x, y, b2);
    }

    public double getSampleDouble(int x, int y, int b2) throws PixelOutsideImageException {
        int tileY;
        int tileX = this.XToTileX(x);
        Raster t = this.getTile(tileX, tileY = this.YToTileY(y));
        if (t == null) {
            throw new PixelOutsideImageException(x, y, b2);
        }
        return t.getSampleDouble(x, y, b2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSample(int x, int y, int b2, int value) throws PixelOutsideImageException {
        int tileX = this.XToTileX(x);
        int tileY = this.YToTileY(y);
        try {
            WritableRaster t = this.getWritableTile(tileX, tileY);
            if (t == null) {
                throw new PixelOutsideImageException(x, y, b2);
            }
            t.setSample(x, y, b2, value);
        }
        finally {
            this.releaseWritableTile(tileX, tileY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSample(int x, int y, int b2, float value) throws PixelOutsideImageException {
        int tileX = this.XToTileX(x);
        int tileY = this.YToTileY(y);
        try {
            WritableRaster t = this.getWritableTile(tileX, tileY);
            if (t == null) {
                throw new PixelOutsideImageException(x, y, b2);
            }
            t.setSample(x, y, b2, value);
        }
        finally {
            this.releaseWritableTile(tileX, tileY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSample(int x, int y, int b2, double value) throws PixelOutsideImageException {
        int tileX = this.XToTileX(x);
        int tileY = this.YToTileY(y);
        try {
            WritableRaster t = this.getWritableTile(tileX, tileY);
            if (t == null) {
                throw new PixelOutsideImageException(x, y, b2);
            }
            t.setSample(x, y, b2, value);
        }
        finally {
            this.releaseWritableTile(tileX, tileY);
        }
    }

    @Override
    public void setData(Raster data) {
        if (data == null) {
            throw new IllegalArgumentException("The data argument must not be null");
        }
        Rectangle rBounds = data.getBounds();
        Rectangle common = rBounds.intersection(this.getBounds());
        if (common.isEmpty()) {
            return;
        }
        int minTileX = this.XToTileX(common.x);
        int maxTileX = this.XToTileX(common.x + common.width - 1);
        int minTileY = this.YToTileY(common.y);
        int maxTileY = this.YToTileY(common.y + common.height - 1);
        for (int y = minTileY; y <= maxTileY; ++y) {
            for (int x = minTileX; x <= maxTileX; ++x) {
                WritableRaster tile = this.getWritableTile(x, y);
                Rectangle tileOverlap = tile.getBounds().intersection(common);
                Raster dataChild = data.createChild(tileOverlap.x, tileOverlap.y, tileOverlap.width, tileOverlap.height, tileOverlap.x, tileOverlap.y, null);
                WritableRaster tChild = tile.createWritableChild(tileOverlap.x, tileOverlap.y, tileOverlap.width, tileOverlap.height, tileOverlap.x, tileOverlap.y, null);
                tChild.setRect(dataChild);
            }
        }
    }

    public Graphics2D createGraphics() {
        int dataType = this.getSampleModel().getDataType();
        if (dataType == 0 || dataType == 3 || dataType == 2 || dataType == 1) {
            return new DiskMemImageGraphics(this);
        }
        throw new UnsupportedOperationException("Image must have an integral data type");
    }

    public long getMemoryCapacity() {
        return this.getTileCache().getMemoryCapacity();
    }

    public long getTileMemorySize() {
        return this.tileMemorySize;
    }

    public void setUseCommonCache(boolean useCommon) {
        if (useCommon && !this.isUsingCommonCache()) {
            if (this.tileCache != null) {
                int y = this.getMinTileY();
                for (int ny = 0; ny < this.getNumYTiles(); ++ny) {
                    int x = this.getMinTileX();
                    for (int nx = 0; nx < this.getNumXTiles(); ++nx) {
                        Raster tile = this.tileCache.getTile(this, x, y);
                        if (tile != null) {
                            DiskMemImage.getCommonTileCache().add(this, x, y, (WritableRaster)tile);
                            this.tileCache.remove(this, x, y);
                        }
                        ++x;
                    }
                    ++y;
                }
            }
            this.tileCache = DiskMemImage.getCommonTileCache();
        } else if (this.isUsingCommonCache()) {
            DiskMemTileCache newCache = DiskMemImage.createNewCache();
            int y = this.getMinTileY();
            for (int ny = 0; ny < this.getNumYTiles(); ++ny) {
                int x = this.getMinTileX();
                for (int nx = 0; nx < this.getNumXTiles(); ++nx) {
                    Raster tile = DiskMemImage.getCommonTileCache().getTile(this, x, y);
                    if (tile != null) {
                        newCache.add(this, x, y, (WritableRaster)tile);
                        DiskMemImage.getCommonTileCache().remove(this, x, y);
                    }
                    ++x;
                }
                ++y;
            }
            this.tileCache = newCache;
        }
    }

    public DiskMemTileCache getTileCache() {
        if (this.tileCache == null) {
            this.tileCache = DiskMemImage.createNewCache();
        }
        return this.tileCache;
    }

    public boolean isUsingCommonCache() {
        return this.tileCache != null && this.tileCache == commonCache;
    }

    private WritableRaster createTile(int tileX, int tileY) {
        assert (this.getTileCache().getTile(this, tileX, tileY) == null);
        Point location = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        return this.createWritableRaster(this.getSampleModel(), location);
    }
}

