/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.util;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.CRS;
import org.geotools.util.Utilities;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.PropertyName;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class FeatureUtilities {
    static FeatureTypeFactory typeFactory;
    static FeatureFactory featureFactory;
    public static final FilterFactory2 DEFAULT_FILTER_FACTORY;
    public static final PropertyName GRID_PROPERTY_NAME;
    public static final PropertyName PARAMS_PROPERTY_NAME;
    static final Logger LOGGER;

    private FeatureUtilities() {
    }

    private static FeatureTypeFactory getTypeFactory() {
        if (typeFactory == null) {
            typeFactory = new FeatureTypeFactoryImpl();
        }
        return typeFactory;
    }

    private static FeatureFactory getFeatureFactory() {
        if (featureFactory == null) {
            featureFactory = CommonFactoryFinder.getFeatureFactory(null);
        }
        return featureFactory;
    }

    private static Polygon getPolygon(Rectangle2D rect) {
        return FeatureUtilities.getPolygon(rect, 0);
    }

    public static Polygon getPolygon(Rectangle2D rect, int srid) {
        PrecisionModel pm = new PrecisionModel();
        GeometryFactory gf = new GeometryFactory(pm, srid);
        Coordinate[] coord = new Coordinate[]{new Coordinate(rect.getMinX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMinY())};
        LinearRing ring = gf.createLinearRing(coord);
        return new Polygon(ring, null, gf);
    }

    public static SimpleFeatureCollection wrapGridCoverage(GridCoverage2D coverage) throws TransformException, SchemaException {
        Polygon bounds = FeatureUtilities.getPolygon(coverage.getEnvelope2D());
        CoordinateReferenceSystem sourceCRS = coverage.getCoordinateReferenceSystem2D();
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder(FeatureUtilities.getTypeFactory());
        ftb.setName("GridCoverage");
        ftb.add("geom", Polygon.class, sourceCRS);
        ftb.add("grid", GridCoverage.class);
        SimpleFeatureType schema = ftb.buildFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(schema, FeatureUtilities.getFeatureFactory());
        fb.add((Object)bounds);
        fb.add((Object)coverage);
        SimpleFeature feature = fb.buildFeature(null);
        DefaultFeatureCollection collection = new DefaultFeatureCollection();
        collection.add(feature);
        return collection;
    }

    public static boolean isWrappedCoverage(SimpleFeatureType featureType) {
        if (!"GridCoverage".equals(featureType.getName().getLocalPart())) {
            return false;
        }
        if (featureType.getAttributeCount() != 2) {
            return false;
        }
        AttributeDescriptor polyDescriptor = featureType.getDescriptor("geom");
        if (polyDescriptor == null || !Polygon.class.equals(polyDescriptor.getType().getBinding())) {
            return false;
        }
        AttributeDescriptor gridDescriptor = featureType.getDescriptor("grid");
        return gridDescriptor != null && GridCoverage.class.equals(gridDescriptor.getType().getBinding());
    }

    public static SimpleFeatureCollection wrapGridCoverageReader(GridCoverage2DReader gridCoverageReader, GeneralParameterValue[] params) throws TransformException, FactoryRegistryException, SchemaException {
        PrecisionModel pm = new PrecisionModel();
        GeometryFactory gf = new GeometryFactory(pm, 0);
        Rectangle2D rect = gridCoverageReader.getOriginalEnvelope().toRectangle2D();
        SingleCRS sourceCrs = CRS.getHorizontalCRS(gridCoverageReader.getCoordinateReferenceSystem());
        if (sourceCrs == null) {
            throw new UnsupportedOperationException(Errors.format(31, gridCoverageReader.getCoordinateReferenceSystem()));
        }
        Coordinate[] coord = new Coordinate[]{new Coordinate(rect.getMinX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMinY())};
        LinearRing ring = gf.createLinearRing(coord);
        Polygon bounds = new Polygon(ring, null, gf);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder(FeatureUtilities.getTypeFactory());
        ftb.setName("GridCoverage");
        ftb.add("geom", Polygon.class, (CoordinateReferenceSystem)sourceCrs);
        ftb.add("grid", GridCoverage2DReader.class);
        ftb.add("params", GeneralParameterValue[].class);
        SimpleFeatureType schema = ftb.buildFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(schema, FeatureUtilities.getFeatureFactory());
        fb.add((Object)bounds);
        fb.add((Object)gridCoverageReader);
        fb.add((Object)params);
        SimpleFeature feature = fb.buildFeature(null);
        DefaultFeatureCollection collection = new DefaultFeatureCollection();
        collection.add(feature);
        return collection;
    }

    public static boolean isWrappedCoverageReader(SimpleFeatureType featureType) {
        if (!"GridCoverage".equals(featureType.getName().getLocalPart())) {
            return false;
        }
        if (featureType.getAttributeCount() != 3) {
            return false;
        }
        AttributeDescriptor polyDescriptor = featureType.getDescriptor("geom");
        if (polyDescriptor == null || !Polygon.class.equals(polyDescriptor.getType().getBinding())) {
            return false;
        }
        AttributeDescriptor gridDescriptor = featureType.getDescriptor("grid");
        if (gridDescriptor == null || !GridCoverage2DReader.class.equals(gridDescriptor.getType().getBinding())) {
            return false;
        }
        AttributeDescriptor paramDescriptor = featureType.getDescriptor("params");
        return paramDescriptor != null && GeneralParameterValue[].class.equals(paramDescriptor.getType().getBinding());
    }

    public static java.awt.Polygon convertPolygon(Polygon roiInput, MathTransform worldToGridTransform) throws TransformException {
        return FeatureUtilities.convertPolygonToPointArray(roiInput, worldToGridTransform, null);
    }

    public static java.awt.Polygon convertPolygonToPointArray(Polygon roiInput, MathTransform worldToGridTransform, List<Point2D> points) throws TransformException {
        boolean isIdentity = worldToGridTransform.isIdentity();
        double[] coords = new double[2];
        LinearRing exteriorRing = roiInput.getExteriorRing();
        CoordinateSequence exteriorRingCS = exteriorRing.getCoordinateSequence();
        int numCoords = exteriorRingCS.size();
        java.awt.Polygon retValue = new java.awt.Polygon();
        for (int i = 0; i < numCoords; ++i) {
            coords[0] = exteriorRingCS.getX(i);
            coords[1] = exteriorRingCS.getY(i);
            if (!isIdentity) {
                worldToGridTransform.transform(coords, 0, coords, 0, 1);
            }
            int x = (int)Math.round(coords[0]);
            int y = (int)Math.round(coords[1]);
            if (points != null) {
                points.add(new Point2D.Double(coords[0], coords[1]));
            }
            retValue.addPoint(x, y);
        }
        return retValue;
    }

    public static Polygon getPolygon(GeneralEnvelope env, GeometryFactory gf) throws IllegalStateException, MismatchedDimensionException {
        Rectangle2D rect = env.toRectangle2D();
        Coordinate[] coord = new Coordinate[]{new Coordinate(rect.getMinX(), rect.getMinY()), new Coordinate(rect.getMinX(), rect.getMaxY()), new Coordinate(rect.getMaxX(), rect.getMaxY()), new Coordinate(rect.getMaxX(), rect.getMinY()), new Coordinate(rect.getMinX(), rect.getMinY())};
        LinearRing ring = gf.createLinearRing(coord);
        Polygon modelSpaceROI = new Polygon(ring, null, gf);
        assert (modelSpaceROI.getEnvelopeInternal().equals(new ReferencedEnvelope(rect, env.getCoordinateReferenceSystem())));
        return modelSpaceROI;
    }

    public static double area(Point2D[] polyPoints) {
        Utilities.ensureNonNull("polyPoints", polyPoints);
        int n = polyPoints.length;
        double area = 0.0;
        for (int i = 0; i < n; ++i) {
            int j = (i + 1) % n;
            area += polyPoints[i].getX() * polyPoints[j].getY();
            area -= polyPoints[j].getX() * polyPoints[i].getY();
        }
        return area /= 2.0;
    }

    static {
        DEFAULT_FILTER_FACTORY = CommonFactoryFinder.getFilterFactory2(GeoTools.getDefaultHints());
        GRID_PROPERTY_NAME = DEFAULT_FILTER_FACTORY.property("grid");
        PARAMS_PROPERTY_NAME = DEFAULT_FILTER_FACTORY.property("params");
        LOGGER = Logging.getLogger(FeatureUtilities.class);
    }
}

