/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.mult;

import org.ejml.data.DMatrix1Row;

public class MatrixMultProduct_DDRM {
    public static void outer(DMatrix1Row a2, DMatrix1Row c2) {
        for (int i = 0; i < a2.numRows; ++i) {
            int indexC1;
            int indexC2 = indexC1 = i * c2.numCols + i;
            int j = i;
            while (j < a2.numRows) {
                int indexA = i * a2.numCols;
                int indexB = j * a2.numCols;
                double sum = 0.0;
                int end = indexA + a2.numCols;
                while (indexA < end) {
                    sum += a2.data[indexA] * a2.data[indexB];
                    ++indexA;
                    ++indexB;
                }
                int n = indexC1++;
                double d2 = sum;
                c2.data[n] = d2;
                c2.data[indexC2] = d2;
                ++j;
                indexC2 += c2.numCols;
            }
        }
    }

    public static void inner_small(DMatrix1Row a2, DMatrix1Row c2) {
        for (int i = 0; i < a2.numCols; ++i) {
            for (int j = i; j < a2.numCols; ++j) {
                int indexC1 = i * c2.numCols + j;
                int indexC2 = j * c2.numCols + i;
                int indexA = i;
                int indexB = j;
                double sum = 0.0;
                int end = indexA + a2.numRows * a2.numCols;
                while (indexA < end) {
                    sum += a2.data[indexA] * a2.data[indexB];
                    indexA += a2.numCols;
                    indexB += a2.numCols;
                }
                c2.data[indexC1] = c2.data[indexC2] = sum;
            }
        }
    }

    public static void inner_reorder(DMatrix1Row a2, DMatrix1Row c2) {
        for (int i = 0; i < a2.numCols; ++i) {
            int indexC = i * c2.numCols + i;
            double valAi = a2.data[i];
            for (int j = i; j < a2.numCols; ++j) {
                c2.data[indexC++] = valAi * a2.data[j];
            }
            for (int k = 1; k < a2.numRows; ++k) {
                indexC = i * c2.numCols + i;
                int indexB = k * a2.numCols + i;
                valAi = a2.data[indexB];
                for (int j = i; j < a2.numCols; ++j) {
                    int n = indexC++;
                    c2.data[n] = c2.data[n] + valAi * a2.data[indexB++];
                }
            }
            int indexC2 = indexC = i * c2.numCols + i;
            int j = i;
            while (j < a2.numCols) {
                c2.data[indexC2] = c2.data[indexC++];
                ++j;
                indexC2 += c2.numCols;
            }
        }
    }

    public static void inner_reorder_upper(DMatrix1Row a2, DMatrix1Row c2) {
        for (int i = 0; i < a2.numCols; ++i) {
            int indexC = i * c2.numCols + i;
            double valAi = a2.data[i];
            for (int j = i; j < a2.numCols; ++j) {
                c2.data[indexC++] = valAi * a2.data[j];
            }
            for (int k = 1; k < a2.numRows; ++k) {
                indexC = i * c2.numCols + i;
                int indexB = k * a2.numCols + i;
                valAi = a2.data[indexB];
                for (int j = i; j < a2.numCols; ++j) {
                    int n = indexC++;
                    c2.data[n] = c2.data[n] + valAi * a2.data[indexB++];
                }
            }
        }
    }
}

