/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.dynamic;

import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public abstract class SetDynamicFilter
implements ISet {
    protected SetDynamicFilterIterator iter = this.createIterator();

    @Override
    public SetDynamicFilterIterator iterator() {
        this.iter.reset();
        return this.iter;
    }

    protected abstract SetDynamicFilterIterator createIterator();

    @Override
    public SetDynamicFilterIterator newIterator() {
        SetDynamicFilterIterator iterator = this.createIterator();
        iterator.reset();
        return iterator;
    }

    @Override
    public boolean add(int element) {
        throw new UnsupportedOperationException("this set is read-only");
    }

    @Override
    public boolean remove(int element) {
        throw new UnsupportedOperationException("this set is read-only");
    }

    @Override
    public abstract boolean contains(int var1);

    @Override
    public void clear() {
        throw new UnsupportedOperationException("this set is read-only");
    }

    @Override
    public int size() {
        int size = 0;
        SetDynamicFilterIterator iterator = this.newIterator();
        while (iterator.hasNext()) {
            ++size;
            iterator.findNext();
        }
        return size;
    }

    @Override
    public int min() {
        int minVal = Integer.MAX_VALUE;
        SetDynamicFilterIterator iterator = this.newIterator();
        while (iterator.hasNext()) {
            int current = iterator.nextInt();
            if (current >= minVal) continue;
            minVal = current;
        }
        return minVal;
    }

    @Override
    public int max() {
        int maxVal = Integer.MIN_VALUE;
        SetDynamicFilterIterator iterator = this.newIterator();
        while (iterator.hasNext()) {
            int current = iterator.nextInt();
            if (current <= maxVal) continue;
            maxVal = current;
        }
        return maxVal;
    }

    @Override
    public SetType getSetType() {
        return SetType.DYNAMIC;
    }

    @Override
    public void registerObserver(ISet set, int idx) {
        throw new UnsupportedOperationException("SetDynamicFilter is not (yet) observable");
    }

    public String toString() {
        StringBuilder st = new StringBuilder("{");
        SetDynamicFilterIterator iter = this.newIterator();
        while (iter.hasNext()) {
            st.append(iter.nextInt()).append(", ");
        }
        st.append("}");
        return st.toString().replace(", }", "}");
    }

    public abstract class SetDynamicFilterIterator
    implements ISetIterator {
        protected Integer next = null;

        protected abstract void resetPointers();

        @Override
        public void reset() {
            this.resetPointers();
            this.findNext();
        }

        @Override
        public int nextInt() {
            int value = this.next;
            this.findNext();
            return value;
        }

        protected abstract void findNext();

        @Override
        public boolean hasNext() {
            return this.next != null;
        }
    }
}

