/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects;

public class PriorityQueue {
    private final int n;
    private final int[] indices;
    private final int[] values;
    private final int[] pointers;
    private int first;
    private int lastElt;

    public PriorityQueue(int _n) {
        this.n = _n;
        this.indices = new int[_n];
        this.pointers = new int[_n];
        this.values = new int[_n];
        this.clear();
    }

    public boolean addElement(int index, int value) {
        int j = -1;
        if (this.lastElt == this.n) {
            return false;
        }
        this.indices[this.lastElt] = index;
        this.values[this.lastElt] = value;
        int i = this.first;
        while (i != -1 && this.values[i] <= value) {
            j = i;
            i = this.pointers[i];
        }
        this.pointers[this.lastElt] = i;
        if (j == -1) {
            this.first = this.lastElt;
        } else {
            this.pointers[j] = this.lastElt;
        }
        ++this.lastElt;
        return true;
    }

    public int pop() {
        if (this.isEmpty()) {
            return -1;
        }
        int elt = this.indices[this.first];
        this.first = this.pointers[this.first];
        return elt;
    }

    public boolean isEmpty() {
        return this.first == -1;
    }

    public void clear() {
        this.first = -1;
        this.lastElt = 0;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder("<");
        int i = this.first;
        while (i != -1) {
            s2.append(" ").append(this.indices[i]);
            i = this.pointers[i];
        }
        s2.append(" >");
        return s2.toString();
    }
}

