/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.delta;

import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;

public abstract class SetViewOnSetsDeltaMonitor
implements ISetDeltaMonitor {
    protected ISetDeltaMonitor[] deltaMonitors;
    protected ISet[] addedValues;
    protected ISet[] removedValues;

    public SetViewOnSetsDeltaMonitor(ISetDeltaMonitor ... deltaMonitors) {
        this.deltaMonitors = deltaMonitors;
        this.addedValues = new ISet[deltaMonitors.length];
        this.removedValues = new ISet[deltaMonitors.length];
        for (int i = 0; i < deltaMonitors.length; ++i) {
            this.addedValues[i] = SetFactory.makeSmallBipartiteSet();
            this.removedValues[i] = SetFactory.makeSmallBipartiteSet();
        }
    }

    protected void fillValues() throws ContradictionException {
        for (int i = 0; i < this.deltaMonitors.length; ++i) {
            int finalI = i;
            this.addedValues[i].clear();
            this.removedValues[i].clear();
            this.deltaMonitors[i].forEach(e2 -> this.addedValues[finalI].add(e2), SetEventType.ADD_TO_KER);
            this.deltaMonitors[i].forEach(e2 -> this.removedValues[finalI].add(e2), SetEventType.REMOVE_FROM_ENVELOPE);
        }
    }

    @Override
    public void startMonitoring() {
        for (int i = 0; i < this.deltaMonitors.length; ++i) {
            this.deltaMonitors[i].startMonitoring();
        }
    }
}

