/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.algebra.constant;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public final class OperationConstOpImage
extends ColormapOpImage {
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    private final boolean hasNoData;
    private Range noData;
    private byte[][] byteLookupTable;
    private final boolean hasROI;
    private ROI roi;
    private final boolean caseA;
    private final boolean caseB;
    private final boolean caseC;
    private AlgebraDescriptor.Operator op;
    private byte destNoDataByte;
    private short destNoDataShort;
    private int destNoDataInt;
    private float destNoDataFloat;
    private double destNoDataDouble;
    private double[] constants;
    private Rectangle roiBounds;
    private PlanarImage roiImage;

    public OperationConstOpImage(RenderedImage source, Map config, ImageLayout layout, AlgebraDescriptor.Operator op, double[] constants, ROI srcROI, Range noData, double destinationNoData) {
        super(source, layout, config, true);
        if (op == null) {
            throw new IllegalArgumentException("Operation Not Defined");
        }
        this.op = op;
        if (!op.supportsMultipleValues()) {
            throw new IllegalArgumentException("Wrong Operation Defined");
        }
        int srcDataType = source.getSampleModel().getDataType();
        int dataType = this.getSampleModel().getDataType();
        if (!op.isDataTypeSupported(srcDataType)) {
            throw new IllegalArgumentException("This operation does not support DataType: " + srcDataType);
        }
        if (constants == null || constants.length == 0) {
            throw new IllegalArgumentException("Constants not defined");
        }
        int numBands = this.getSampleModel().getNumBands();
        if (constants.length < numBands) {
            this.constants = new double[numBands];
            for (int i = 0; i < numBands; ++i) {
                this.constants[i] = constants[0];
            }
        } else {
            this.constants = (double[])constants.clone();
        }
        this.destNoDataDouble = destinationNoData;
        switch (dataType) {
            case 0: {
                this.destNoDataByte = ImageUtil.clampRoundByte(destinationNoData);
                break;
            }
            case 1: {
                this.destNoDataShort = ImageUtil.clampRoundUShort(destinationNoData);
                break;
            }
            case 2: {
                this.destNoDataShort = ImageUtil.clampRoundShort(destinationNoData);
                break;
            }
            case 3: {
                this.destNoDataInt = ImageUtil.clampRoundInt(destinationNoData);
                break;
            }
            case 4: {
                this.destNoDataFloat = ImageUtil.clampFloat(destinationNoData);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong image data type");
            }
        }
        if (noData != null) {
            this.hasNoData = true;
            this.noData = noData;
        } else {
            this.hasNoData = false;
        }
        if (srcROI != null) {
            this.hasROI = true;
            this.roi = srcROI;
            this.roiBounds = this.roi.getBounds();
        } else {
            this.hasROI = false;
            this.roi = null;
        }
        this.caseA = !this.hasNoData && !this.hasROI;
        this.caseB = !this.hasNoData && this.hasROI;
        this.caseC = this.hasNoData && !this.hasROI;
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
        if (dataType == 0) {
            this.initByteTable();
        }
    }

    private void initByteTable() {
        if (this.byteLookupTable != null) {
            return;
        }
        int nbands = this.constants.length;
        this.byteLookupTable = new byte[nbands][256];
        boolean supportsFloat = this.op.isDataTypeSupported(4);
        for (int band = 0; band < nbands; ++band) {
            int k = ImageUtil.clampRoundInt(this.constants[band]);
            float kF = (float)this.constants[band];
            byte[] t = this.byteLookupTable[band];
            for (int i = 0; i < 256; ++i) {
                t[i] = this.hasNoData && this.noData.contains((byte)i) ? this.destNoDataByte : (supportsFloat ? ImageUtil.clampRoundByte(this.op.calculate(new float[]{i, kF})) : ImageUtil.clampByte(this.op.calculate(i, k)));
            }
        }
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor src = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dst = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(destRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiTile = this.roi.intersect(new ROIShape(srcRectExpanded));
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = this.getImage();
                        roiIter = RandomIterFactory.create(roiIMG, null, true, true);
                    }
                }
            }
        }
        if (!this.hasROI || !roiDisjointTile) {
            switch (dst.getDataType()) {
                case 0: {
                    this.computeRectByte(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 1: {
                    this.computeRectUShort(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 2: {
                    this.computeRectShort(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 3: {
                    this.computeRectInt(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 4: {
                    this.computeRectFloat(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 5: {
                    this.computeRectDouble(src, dst, roiIter, roiContainsTile);
                }
            }
            if (dst.isDataCopy()) {
                dst.clampDataArrays();
                dst.copyDataToRaster();
            }
        } else {
            double[] bkg = new double[dest.getSampleModel().getNumBands()];
            Arrays.fill(bkg, this.destNoDataDouble);
            ImageUtil.fillBackground(dest, destRect, bkg);
        }
    }

    private void computeRectByte(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        byte[][] srcData = src.getByteDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        byte[][] dData = dst.getByteDataArrays();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.hasROI && !roiContainsTile) {
            for (int b2 = 0; b2 < dstBands; ++b2) {
                byte[] d2 = dData[b2];
                byte[] s2 = srcData[b2];
                byte[] bandTable = this.byteLookupTable[b2];
                int dstLineOffset = dBandOffsets[b2];
                int srcLineOffset = srcBandOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h2;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                            d2[dstPixelOffset] = this.destNoDataByte;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d2[dstPixelOffset] = bandTable[s2[srcPixelOffset] & 0xFF];
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else {
            for (int b3 = 0; b3 < dstBands; ++b3) {
                byte[] d3 = dData[b3];
                byte[] s3 = srcData[b3];
                byte[] bandTable = this.byteLookupTable[b3];
                int dstLineOffset = dBandOffsets[b3];
                int srcLineOffset = srcBandOffsets[b3];
                for (int h3 = 0; h3 < dstHeight; ++h3) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d3[dstPixelOffset] = bandTable[s3[srcPixelOffset] & 0xFF];
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectUShort(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        boolean supportsFloat = this.op.isDataTypeSupported(4);
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int b2 = 0; b2 < dstBands; ++b2) {
                int c2 = ImageUtil.clampRoundInt(this.constants[b2]);
                float cf = (float)this.constants[b2];
                short[] d2 = dData[b2];
                short[] s2 = srcData[b2];
                int dstLineOffset = dBandOffsets[b2];
                int srcLineOffset = srcBandOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = this.op.isUshortSupported() ? (supportsFloat ? (short)this.op.calculate(new float[]{s2[srcPixelOffset], cf}) : (short)this.op.calculate(s2[srcPixelOffset], c2)) : (supportsFloat ? ImageUtil.clampRoundUShort(this.op.calculate(new float[]{s2[srcPixelOffset] & 0xFFFF, cf})) : ImageUtil.clampUShort(this.op.calculate(s2[srcPixelOffset] & 0xFFFF, c2)));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b3 = 0; b3 < dstBands; ++b3) {
                int c3 = ImageUtil.clampRoundInt(this.constants[b3]);
                float cf = (float)this.constants[b3];
                short[] d3 = dData[b3];
                short[] s3 = srcData[b3];
                int dstLineOffset = dBandOffsets[b3];
                int srcLineOffset = srcBandOffsets[b3];
                for (int h3 = 0; h3 < dstHeight; ++h3) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h3;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                            d3[dstPixelOffset] = this.destNoDataShort;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d3[dstPixelOffset] = this.op.isUshortSupported() ? (supportsFloat ? (short)this.op.calculate(new float[]{s3[srcPixelOffset], cf}) : (short)this.op.calculate(s3[srcPixelOffset], c3)) : (supportsFloat ? ImageUtil.clampRoundUShort(this.op.calculate(new float[]{s3[srcPixelOffset] & 0xFFFF, cf})) : ImageUtil.clampUShort(this.op.calculate(s3[srcPixelOffset] & 0xFFFF, c3)));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int b4 = 0; b4 < dstBands; ++b4) {
                int c4 = ImageUtil.clampRoundInt(this.constants[b4]);
                float cf = (float)this.constants[b4];
                short[] d4 = dData[b4];
                short[] s4 = srcData[b4];
                int dstLineOffset = dBandOffsets[b4];
                int srcLineOffset = srcBandOffsets[b4];
                for (int h4 = 0; h4 < dstHeight; ++h4) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        if (this.noData.contains(s4[srcPixelOffset])) {
                            d4[dstPixelOffset] = this.destNoDataShort;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d4[dstPixelOffset] = this.op.isUshortSupported() ? (supportsFloat ? (short)this.op.calculate(new float[]{s4[srcPixelOffset], cf}) : (short)this.op.calculate(s4[srcPixelOffset], c4)) : (supportsFloat ? ImageUtil.clampRoundUShort(this.op.calculate(new float[]{s4[srcPixelOffset] & 0xFFFF, cf})) : ImageUtil.clampUShort(this.op.calculate(s4[srcPixelOffset] & 0xFFFF, c4)));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else {
            for (int b5 = 0; b5 < dstBands; ++b5) {
                int c5 = ImageUtil.clampRoundInt(this.constants[b5]);
                float cf = (float)this.constants[b5];
                short[] d5 = dData[b5];
                short[] s5 = srcData[b5];
                int dstLineOffset = dBandOffsets[b5];
                int srcLineOffset = srcBandOffsets[b5];
                for (int h5 = 0; h5 < dstHeight; ++h5) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h5;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0 || this.noData.contains(s5[srcPixelOffset])) {
                            d5[dstPixelOffset] = this.destNoDataShort;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d5[dstPixelOffset] = this.op.isUshortSupported() ? (supportsFloat ? (short)this.op.calculate(new float[]{s5[srcPixelOffset], cf}) : (short)this.op.calculate(s5[srcPixelOffset], c5)) : (supportsFloat ? ImageUtil.clampRoundUShort(this.op.calculate(new float[]{s5[srcPixelOffset] & 0xFFFF, cf})) : ImageUtil.clampUShort(this.op.calculate(s5[srcPixelOffset] & 0xFFFF, c5)));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        boolean supportsFloat = this.op.isDataTypeSupported(4);
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int b2 = 0; b2 < dstBands; ++b2) {
                int c2 = ImageUtil.clampRoundInt(this.constants[b2]);
                float cf = (float)this.constants[b2];
                short[] d2 = dData[b2];
                short[] s2 = srcData[b2];
                int dstLineOffset = dBandOffsets[b2];
                int srcLineOffset = srcBandOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = supportsFloat ? ImageUtil.clampRoundShort(this.op.calculate(new float[]{s2[srcPixelOffset], cf})) : ImageUtil.clampShort(this.op.calculate(s2[srcPixelOffset], c2));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b3 = 0; b3 < dstBands; ++b3) {
                int c3 = ImageUtil.clampRoundInt(this.constants[b3]);
                float cf = (float)this.constants[b3];
                short[] d3 = dData[b3];
                short[] s3 = srcData[b3];
                int dstLineOffset = dBandOffsets[b3];
                int srcLineOffset = srcBandOffsets[b3];
                for (int h3 = 0; h3 < dstHeight; ++h3) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h3;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                            d3[dstPixelOffset] = this.destNoDataShort;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d3[dstPixelOffset] = supportsFloat ? ImageUtil.clampRoundShort(this.op.calculate(new float[]{s3[srcPixelOffset], cf})) : ImageUtil.clampShort(this.op.calculate(s3[srcPixelOffset], c3));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int b4 = 0; b4 < dstBands; ++b4) {
                int c4 = ImageUtil.clampRoundInt(this.constants[b4]);
                float cf = (float)this.constants[b4];
                short[] d4 = dData[b4];
                short[] s4 = srcData[b4];
                int dstLineOffset = dBandOffsets[b4];
                int srcLineOffset = srcBandOffsets[b4];
                for (int h4 = 0; h4 < dstHeight; ++h4) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        if (this.noData.contains(s4[srcPixelOffset])) {
                            d4[dstPixelOffset] = this.destNoDataShort;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d4[dstPixelOffset] = supportsFloat ? ImageUtil.clampRoundShort(this.op.calculate(new float[]{s4[srcPixelOffset], cf})) : ImageUtil.clampShort(this.op.calculate(s4[srcPixelOffset], c4));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else {
            for (int b5 = 0; b5 < dstBands; ++b5) {
                int c5 = ImageUtil.clampRoundInt(this.constants[b5]);
                float cf = (float)this.constants[b5];
                short[] d5 = dData[b5];
                short[] s5 = srcData[b5];
                int dstLineOffset = dBandOffsets[b5];
                int srcLineOffset = srcBandOffsets[b5];
                for (int h5 = 0; h5 < dstHeight; ++h5) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h5;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0 || this.noData.contains(s5[srcPixelOffset])) {
                            d5[dstPixelOffset] = this.destNoDataShort;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d5[dstPixelOffset] = supportsFloat ? ImageUtil.clampRoundShort(this.op.calculate(new float[]{s5[srcPixelOffset], cf})) : ImageUtil.clampShort(this.op.calculate(s5[srcPixelOffset], c5));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int[][] srcData = src.getIntDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        int[][] dData = dst.getIntDataArrays();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        boolean supportsDouble = this.op.isDataTypeSupported(5);
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int b2 = 0; b2 < dstBands; ++b2) {
                long c2 = ImageUtil.clampRoundInt(this.constants[b2]);
                int[] d2 = dData[b2];
                int[] s2 = srcData[b2];
                int dstLineOffset = dBandOffsets[b2];
                int srcLineOffset = srcBandOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = supportsDouble ? ImageUtil.clampRoundInt(this.op.calculate(s2[srcPixelOffset], this.constants[b2])) : ImageUtil.clampInt(this.op.calculateL(s2[srcPixelOffset], c2));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b3 = 0; b3 < dstBands; ++b3) {
                long c3 = ImageUtil.clampRoundInt(this.constants[b3]);
                int[] d3 = dData[b3];
                int[] s3 = srcData[b3];
                int dstLineOffset = dBandOffsets[b3];
                int srcLineOffset = srcBandOffsets[b3];
                for (int h3 = 0; h3 < dstHeight; ++h3) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h3;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                            d3[dstPixelOffset] = this.destNoDataInt;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d3[dstPixelOffset] = supportsDouble ? ImageUtil.clampRoundInt(this.op.calculate(s3[srcPixelOffset], this.constants[b3])) : ImageUtil.clampInt(this.op.calculateL(s3[srcPixelOffset], c3));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int b4 = 0; b4 < dstBands; ++b4) {
                long c4 = ImageUtil.clampRoundInt(this.constants[b4]);
                int[] d4 = dData[b4];
                int[] s4 = srcData[b4];
                int dstLineOffset = dBandOffsets[b4];
                int srcLineOffset = srcBandOffsets[b4];
                for (int h4 = 0; h4 < dstHeight; ++h4) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        if (this.noData.contains(s4[srcPixelOffset])) {
                            d4[dstPixelOffset] = this.destNoDataInt;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d4[dstPixelOffset] = supportsDouble ? ImageUtil.clampRoundInt(this.op.calculate(s4[srcPixelOffset], this.constants[b4])) : ImageUtil.clampInt(this.op.calculateL(s4[srcPixelOffset], c4));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else {
            for (int b5 = 0; b5 < dstBands; ++b5) {
                long c5 = ImageUtil.clampRoundInt(this.constants[b5]);
                int[] d5 = dData[b5];
                int[] s5 = srcData[b5];
                int dstLineOffset = dBandOffsets[b5];
                int srcLineOffset = srcBandOffsets[b5];
                for (int h5 = 0; h5 < dstHeight; ++h5) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h5;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0 || this.noData.contains(s5[srcPixelOffset])) {
                            d5[dstPixelOffset] = this.destNoDataInt;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d5[dstPixelOffset] = supportsDouble ? ImageUtil.clampRoundInt(this.op.calculate(s5[srcPixelOffset], this.constants[b5])) : ImageUtil.clampInt(this.op.calculateL(s5[srcPixelOffset], c5));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectFloat(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        float[][] srcData = src.getFloatDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        float[][] dData = dst.getFloatDataArrays();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int b2 = 0; b2 < dstBands; ++b2) {
                float[] d2 = dData[b2];
                float[] s2 = srcData[b2];
                int dstLineOffset = dBandOffsets[b2];
                int srcLineOffset = srcBandOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = ImageUtil.clampFloat(this.op.calculate(s2[srcPixelOffset], this.constants[b2]));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b3 = 0; b3 < dstBands; ++b3) {
                float[] d3 = dData[b3];
                float[] s3 = srcData[b3];
                int dstLineOffset = dBandOffsets[b3];
                int srcLineOffset = srcBandOffsets[b3];
                for (int h3 = 0; h3 < dstHeight; ++h3) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h3;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                            d3[dstPixelOffset] = this.destNoDataFloat;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d3[dstPixelOffset] = ImageUtil.clampFloat(this.op.calculate(s3[srcPixelOffset], this.constants[b3]));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int b4 = 0; b4 < dstBands; ++b4) {
                float[] d4 = dData[b4];
                float[] s4 = srcData[b4];
                int dstLineOffset = dBandOffsets[b4];
                int srcLineOffset = srcBandOffsets[b4];
                for (int h4 = 0; h4 < dstHeight; ++h4) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        if (this.noData.contains(s4[srcPixelOffset])) {
                            d4[dstPixelOffset] = this.destNoDataFloat;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d4[dstPixelOffset] = ImageUtil.clampFloat(this.op.calculate(s4[srcPixelOffset], this.constants[b4]));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else {
            for (int b5 = 0; b5 < dstBands; ++b5) {
                float[] d5 = dData[b5];
                float[] s5 = srcData[b5];
                int dstLineOffset = dBandOffsets[b5];
                int srcLineOffset = srcBandOffsets[b5];
                for (int h5 = 0; h5 < dstHeight; ++h5) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h5;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0 || this.noData.contains(s5[srcPixelOffset])) {
                            d5[dstPixelOffset] = this.destNoDataFloat;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d5[dstPixelOffset] = ImageUtil.clampFloat(this.op.calculate(s5[srcPixelOffset], this.constants[b5]));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectDouble(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        double[][] srcData = src.getDoubleDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        double[][] dData = dst.getDoubleDataArrays();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int b2 = 0; b2 < dstBands; ++b2) {
                double[] d2 = dData[b2];
                double[] s2 = srcData[b2];
                int dstLineOffset = dBandOffsets[b2];
                int srcLineOffset = srcBandOffsets[b2];
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d2[dstPixelOffset] = this.op.calculate(s2[srcPixelOffset], this.constants[b2]);
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b3 = 0; b3 < dstBands; ++b3) {
                double[] d3 = dData[b3];
                double[] s3 = srcData[b3];
                int dstLineOffset = dBandOffsets[b3];
                int srcLineOffset = srcBandOffsets[b3];
                for (int h3 = 0; h3 < dstHeight; ++h3) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h3;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                            d3[dstPixelOffset] = this.destNoDataDouble;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d3[dstPixelOffset] = this.op.calculate(s3[srcPixelOffset], this.constants[b3]);
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int b4 = 0; b4 < dstBands; ++b4) {
                double[] d4 = dData[b4];
                double[] s4 = srcData[b4];
                int dstLineOffset = dBandOffsets[b4];
                int srcLineOffset = srcBandOffsets[b4];
                for (int h4 = 0; h4 < dstHeight; ++h4) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        if (this.noData.contains(s4[srcPixelOffset])) {
                            d4[dstPixelOffset] = this.destNoDataDouble;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d4[dstPixelOffset] = this.op.calculate(s4[srcPixelOffset], this.constants[b4]);
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else {
            for (int b5 = 0; b5 < dstBands; ++b5) {
                double[] d5 = dData[b5];
                double[] s5 = srcData[b5];
                int dstLineOffset = dBandOffsets[b5];
                int srcLineOffset = srcBandOffsets[b5];
                for (int h5 = 0; h5 < dstHeight; ++h5) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h5;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0 || this.noData.contains(s5[srcPixelOffset])) {
                            d5[dstPixelOffset] = this.destNoDataDouble;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d5[dstPixelOffset] = this.op.calculate(s5[srcPixelOffset], this.constants[b5]);
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        }
    }

    @Override
    protected void transformColormap(byte[][] colormap) {
        this.initByteTable();
        for (int b2 = 0; b2 < 3; ++b2) {
            byte[] map = colormap[b2];
            byte[] luTable = this.byteLookupTable[b2 >= this.byteLookupTable.length ? 0 : b2];
            int mapSize = map.length;
            for (int i = 0; i < mapSize; ++i) {
                map[i] = luTable[map[i] & 0xFF];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            OperationConstOpImage operationConstOpImage = this;
            synchronized (operationConstOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }
}

