/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import java.io.IOException;

public class TIFFPackBitsUtil {
    private static final boolean debug = false;
    byte[] dstData = new byte[8192];
    int dstIndex = 0;

    private void ensureCapacity(int bytesToAdd) {
        if (this.dstIndex + bytesToAdd > this.dstData.length) {
            byte[] newDstData = new byte[Math.max((int)((float)this.dstData.length * 1.2f), this.dstIndex + bytesToAdd)];
            System.arraycopy(this.dstData, 0, newDstData, 0, this.dstData.length);
            this.dstData = newDstData;
        }
    }

    public byte[] decode(byte[] srcData) throws IOException {
        int inIndex = 0;
        while (inIndex < srcData.length) {
            byte b2;
            if ((b2 = srcData[inIndex++]) >= 0 && b2 <= 127) {
                this.ensureCapacity(b2 + 1);
                for (int i = 0; i < b2 + 1; ++i) {
                    this.dstData[this.dstIndex++] = srcData[inIndex++];
                }
                continue;
            }
            if (b2 <= -1 && b2 >= -127) {
                byte repeat = srcData[inIndex++];
                this.ensureCapacity(-b2 + 1);
                for (int i = 0; i < -b2 + 1; ++i) {
                    this.dstData[this.dstIndex++] = repeat;
                }
                continue;
            }
            ++inIndex;
        }
        byte[] newDstData = new byte[this.dstIndex];
        System.arraycopy(this.dstData, 0, newDstData, 0, this.dstIndex);
        return newDstData;
    }
}

