/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.ndplugin;

import it.geosolutions.imageio.core.CoreCommonImageMetadata;
import it.geosolutions.imageio.ndplugin.BaseImageReader;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageTypeSpecifier;
import org.w3c.dom.Node;

public abstract class BaseImageMetadata
extends CoreCommonImageMetadata {
    public static final String ATTRIBUTES_NODE = "Attributes";
    protected final BaseImageReader imageReader;
    private int imageIndex;
    private Node commonNativeTree;

    protected BaseImageMetadata(BaseImageReader reader, int imageIndex) {
        super(false, "it_geosolutions_imageio_core_commonImageMetadata_1.0", "it.geosolutions.imageio.core.CommonImageMetadataFormat", null, null);
        if (reader == null) {
            throw new NullPointerException("The provided reader is null");
        }
        this.imageIndex = imageIndex;
        this.imageReader = reader;
        try {
            this.setMembers(this.imageReader);
        }
        catch (IOException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    protected void setMembers(BaseImageReader imageReader) throws IOException {
        this.setWidth(imageReader.getWidth(this.imageIndex));
        this.setHeight(imageReader.getHeight(this.imageIndex));
        this.setTileWidth(imageReader.getTileWidth(this.imageIndex));
        this.setTileHeight(imageReader.getTileHeight(this.imageIndex));
        Iterator<ImageTypeSpecifier> it = imageReader.getImageTypes(this.imageIndex);
        if (it != null && it.hasNext()) {
            ImageTypeSpecifier its = it.next();
            this.setNumBands(its.getSampleModel().getNumBands());
        }
    }

    protected int getImageIndex() {
        return this.imageIndex;
    }

    @Override
    protected synchronized Node createCommonNativeTree() {
        if (this.commonNativeTree == null) {
            this.commonNativeTree = super.createCommonNativeTree();
        }
        return this.commonNativeTree;
    }

    public BaseImageReader getImageReader() {
        return this.imageReader;
    }
}

