/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DImageEncoder;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class PdfBoxGraphics2DLosslessImageEncoder
implements IPdfBoxGraphics2DImageEncoder {
    private Map<ImageSoftReference, SoftReference<PDImageXObject>> imageMap = new HashMap<ImageSoftReference, SoftReference<PDImageXObject>>();
    private Map<ProfileSoftReference, SoftReference<PDColorSpace>> profileMap = new HashMap<ProfileSoftReference, SoftReference<PDColorSpace>>();
    private SoftReference<PDDocument> doc;

    @Override
    public PDImageXObject encodeImage(PDDocument document, PDPageContentStream contentStream, Image image) {
        BufferedImage bi;
        if (image instanceof BufferedImage) {
            bi = (BufferedImage)image;
        } else {
            int height;
            int width = image.getWidth(null);
            bi = new BufferedImage(width, height = image.getHeight(null), 6);
            Graphics graphics = bi.getGraphics();
            if (!graphics.drawImage(image, 0, 0, null, null)) {
                throw new IllegalStateException("Not fully loaded images are not supported.");
            }
            graphics.dispose();
        }
        try {
            SoftReference<PDImageXObject> pdImageXObjectSoftReference;
            PDImageXObject imageXObject;
            if (this.doc == null || this.doc.get() != document) {
                this.imageMap = new HashMap<ImageSoftReference, SoftReference<PDImageXObject>>();
                this.profileMap = new HashMap<ProfileSoftReference, SoftReference<PDColorSpace>>();
                this.doc = new SoftReference<PDDocument>(document);
            }
            PDImageXObject pDImageXObject = imageXObject = (pdImageXObjectSoftReference = this.imageMap.get(new ImageSoftReference(image))) == null ? null : pdImageXObjectSoftReference.get();
            if (imageXObject == null) {
                imageXObject = LosslessFactory.createFromImage((PDDocument)document, (BufferedImage)bi);
                if (bi.getColorModel().getColorSpace() instanceof ICC_ColorSpace) {
                    ICC_Profile profile = ((ICC_ColorSpace)bi.getColorModel().getColorSpace()).getProfile();
                    if (((ICC_ColorSpace)bi.getColorModel().getColorSpace()).getProfile() != ICC_Profile.getInstance(1000)) {
                        PDColorSpace pdProfile;
                        SoftReference<PDColorSpace> pdProfileRef = this.profileMap.get(new ProfileSoftReference(profile));
                        PDColorSpace pDColorSpace = pdProfile = pdProfileRef == null ? null : pdProfileRef.get();
                        if (pdProfile == null && (pdProfile = imageXObject.getColorSpace()) instanceof PDICCBased) {
                            this.profileMap.put(new ProfileSoftReference(profile), new SoftReference<PDColorSpace>(pdProfile));
                        }
                        imageXObject.setColorSpace(pdProfile);
                    }
                }
                this.imageMap.put(new ImageSoftReference(image), new SoftReference<PDImageXObject>(imageXObject));
            }
            return imageXObject;
        }
        catch (IOException e2) {
            throw new RuntimeException("Could not encode Image", e2);
        }
    }

    private class ProfileSoftReference
    extends SoftReference<ICC_Profile> {
        ProfileSoftReference(ICC_Profile referent) {
            super(referent);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            assert (obj instanceof ProfileSoftReference);
            return ((ProfileSoftReference)obj).get() == this.get();
        }

        public int hashCode() {
            ICC_Profile image = (ICC_Profile)this.get();
            if (image == null) {
                return 0;
            }
            return image.hashCode();
        }
    }

    private class ImageSoftReference
    extends SoftReference<Image> {
        ImageSoftReference(Image referent) {
            super(referent);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            assert (obj instanceof ImageSoftReference);
            return ((ImageSoftReference)obj).get() == this.get();
        }

        public int hashCode() {
            Image image = (Image)this.get();
            if (image == null) {
                return 0;
            }
            return image.hashCode();
        }
    }
}

