/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.iupac.parser;

import java.util.List;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.iupac.parser.AttachedGroup;
import org.openscience.cdk.iupac.parser.ParseException;
import org.openscience.cdk.iupac.parser.Token;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

public class MoleculeBuilder {
    private IAtomContainer currentMolecule = null;
    private IAtom endOfChain;

    public MoleculeBuilder(IChemObjectBuilder builder) {
        this.currentMolecule = builder.newInstance(IAtomContainer.class, new Object[0]);
    }

    public MoleculeBuilder() {
        this(DefaultChemObjectBuilder.getInstance());
    }

    private IAtomContainer buildChain(int length, boolean isMainCyclic) {
        IAtomContainer currentChain;
        if (length > 0) {
            if (isMainCyclic) {
                currentChain = this.currentMolecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                currentChain.add(this.currentMolecule.getBuilder().newInstance(IRing.class, length, "C"));
            } else {
                currentChain = MoleculeBuilder.makeAlkane(length);
            }
        } else {
            currentChain = this.currentMolecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        }
        return currentChain;
    }

    private void buildFunGroups(List<AttachedGroup> attachedGroups) {
        for (AttachedGroup attachedGroup : attachedGroups) {
            for (Token locationToken : attachedGroup.getLocations()) {
                this.addFunGroup(attachedGroup.getName(), Integer.parseInt(locationToken.image) - 1);
            }
        }
    }

    private void addFunGroup(String funGroupToken, int addPos) {
        if (!"an".equals(funGroupToken)) {
            if ("en".equals(funGroupToken)) {
                if (addPos < 0) {
                    this.currentMolecule.getBond(0).setOrder(IBond.Order.DOUBLE);
                } else {
                    this.currentMolecule.getBond(addPos).setOrder(IBond.Order.DOUBLE);
                }
            } else if ("yn".equals(funGroupToken)) {
                if (addPos < 0) {
                    this.currentMolecule.getBond(0).setOrder(IBond.Order.TRIPLE);
                } else {
                    this.currentMolecule.getBond(addPos).setOrder(IBond.Order.TRIPLE);
                }
            } else if (!"e".equals(funGroupToken)) {
                if ("ol".equals(funGroupToken) || "hydroxy".equals(funGroupToken)) {
                    if (addPos < 0) {
                        this.addAtom("O", this.endOfChain, IBond.Order.SINGLE, 1);
                    } else {
                        this.addAtom("O", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 1);
                    }
                } else if ("al".equals(funGroupToken)) {
                    this.addAtom("O", this.endOfChain, IBond.Order.DOUBLE, 0);
                } else if ("oic acid".equals(funGroupToken)) {
                    this.addAtom("O", this.endOfChain, IBond.Order.DOUBLE, 0);
                    this.addAtom("O", this.endOfChain, IBond.Order.SINGLE, 1);
                } else if ("oyl chloride".equals(funGroupToken)) {
                    this.addAtom("O", this.endOfChain, IBond.Order.DOUBLE, 0);
                    this.addAtom("Cl", this.endOfChain, IBond.Order.SINGLE, 0);
                } else if ("chloro".equals(funGroupToken)) {
                    if (addPos < 0) {
                        this.addAtom("Cl", this.currentMolecule.isEmpty() ? null : this.currentMolecule.getAtom(0), IBond.Order.SINGLE, 0);
                    } else {
                        this.addAtom("Cl", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 0);
                    }
                } else if ("fluoro".equals(funGroupToken)) {
                    if (addPos < 0) {
                        this.addAtom("F", this.currentMolecule.isEmpty() ? null : this.currentMolecule.getAtom(0), IBond.Order.SINGLE, 0);
                    } else {
                        this.addAtom("F", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 0);
                    }
                } else if ("bromo".equals(funGroupToken)) {
                    if (addPos < 0) {
                        this.addAtom("Br", this.currentMolecule.isEmpty() ? null : this.currentMolecule.getAtom(0), IBond.Order.SINGLE, 0);
                    } else {
                        this.addAtom("Br", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 0);
                    }
                } else if ("iodo".equals(funGroupToken)) {
                    if (addPos < 0) {
                        this.addAtom("I", this.currentMolecule.isEmpty() ? null : this.currentMolecule.getAtom(0), IBond.Order.SINGLE, 0);
                    } else {
                        this.addAtom("I", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 0);
                    }
                } else if ("nitro".equals(funGroupToken)) {
                    if (addPos < 0) {
                        this.addAtom("N", this.currentMolecule.isEmpty() ? null : this.currentMolecule.getAtom(0), IBond.Order.SINGLE, 0);
                    } else {
                        this.addAtom("N", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 0);
                    }
                    IAtom nitrogenAtom = this.currentMolecule.getAtom(this.currentMolecule.getAtomCount());
                    nitrogenAtom.setFormalCharge(1);
                    this.addAtom("O", nitrogenAtom, IBond.Order.SINGLE, 0);
                    this.currentMolecule.getAtom(this.currentMolecule.getAtomCount()).setFormalCharge(-1);
                    this.addAtom("O", nitrogenAtom, IBond.Order.DOUBLE, 0);
                } else if ("oxo".equals(funGroupToken)) {
                    if (addPos < 0) {
                        this.addAtom("O", this.currentMolecule.isEmpty() ? null : this.currentMolecule.getAtom(0), IBond.Order.DOUBLE, 0);
                    } else {
                        this.addAtom("O", this.currentMolecule.getAtom(addPos), IBond.Order.DOUBLE, 0);
                    }
                } else if ("nitrile".equals(funGroupToken)) {
                    this.addAtom("N", this.currentMolecule.isEmpty() ? null : this.currentMolecule.getAtom(0), IBond.Order.TRIPLE, 0);
                } else if ("phenyl".equals(funGroupToken)) {
                    IAtomContainer benzene = MoleculeBuilder.makeBenzene();
                    try {
                        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(benzene);
                        Aromaticity.cdkLegacy().apply(benzene);
                    }
                    catch (CDKException cDKException) {
                        // empty catch block
                    }
                    this.currentMolecule.add(benzene);
                    IBond joiningBond = addPos < 0 ? this.currentMolecule.getBuilder().newInstance(IBond.class, this.currentMolecule.isEmpty() ? null : this.currentMolecule.getAtom(0), benzene.getAtom(0)) : this.currentMolecule.getBuilder().newInstance(IBond.class, this.currentMolecule.getAtom(addPos), benzene.getAtom(0));
                    this.currentMolecule.addBond(joiningBond);
                } else if ("amino".equals(funGroupToken)) {
                    if (addPos < 0) {
                        this.addAtom("N", this.currentMolecule.isEmpty() ? null : this.currentMolecule.getAtom(0), IBond.Order.SINGLE, 2);
                    } else {
                        this.addAtom("N", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 2);
                    }
                } else if ("alumino".equals(funGroupToken)) {
                    if (addPos < 0) {
                        this.addAtom("Al", this.currentMolecule.isEmpty() ? null : this.currentMolecule.getAtom(0), IBond.Order.SINGLE, 2);
                    } else {
                        this.addAtom("Al", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 2);
                    }
                } else if ("litho".equals(funGroupToken)) {
                    if (addPos < 0) {
                        this.addAtom("Li", this.currentMolecule.isEmpty() ? null : this.currentMolecule.getAtom(0), IBond.Order.SINGLE, 2);
                    } else {
                        this.addAtom("Li", this.currentMolecule.getAtom(addPos), IBond.Order.SINGLE, 2);
                    }
                } else if ("oate".equals(funGroupToken)) {
                    this.addAtom("O", this.endOfChain, IBond.Order.DOUBLE, 0);
                    this.addAtom("O", this.endOfChain, IBond.Order.SINGLE, 0);
                    this.endOfChain = this.currentMolecule.getAtom(this.currentMolecule.getAtomCount());
                } else if ("amine".equals(funGroupToken)) {
                    this.addAtom("N", this.endOfChain, IBond.Order.SINGLE, 1);
                    this.endOfChain = this.currentMolecule.getAtom(this.currentMolecule.getAtomCount());
                } else if ("amide".equals(funGroupToken)) {
                    this.addAtom("O", this.endOfChain, IBond.Order.DOUBLE, 0);
                    this.addAtom("N", this.endOfChain, IBond.Order.SINGLE, 1);
                    this.endOfChain = this.currentMolecule.getAtom(this.currentMolecule.getAtomCount());
                } else if ("one".equals(funGroupToken)) {
                    this.addAtom("O", this.endOfChain, IBond.Order.DOUBLE, 2);
                } else if (this.getMetalAtomicSymbol(funGroupToken) != null) {
                    this.currentMolecule.addAtom(this.currentMolecule.getBuilder().newInstance(IAtom.class, this.getMetalAtomicSymbol(funGroupToken)));
                    this.endOfChain = this.currentMolecule.getAtom(this.currentMolecule.getAtomCount());
                }
            }
        }
    }

    String getMetalAtomicSymbol(String metalName) {
        if ("aluminium".equals(metalName)) {
            return "Al";
        }
        if ("magnesium".equals(metalName)) {
            return "Mg";
        }
        if ("gallium".equals(metalName)) {
            return "Ga";
        }
        if ("indium".equals(metalName)) {
            return "In";
        }
        if ("thallium".equals(metalName)) {
            return "Tl";
        }
        if ("germanium".equals(metalName)) {
            return "Ge";
        }
        if ("tin".equals(metalName)) {
            return "Sn";
        }
        if ("lead".equals(metalName)) {
            return "Pb";
        }
        if ("arsenic".equals(metalName)) {
            return "As";
        }
        if ("antimony".equals(metalName)) {
            return "Sb";
        }
        if ("bismuth".equals(metalName)) {
            return "Bi";
        }
        return null;
    }

    private void addAtom(String newAtomType, IAtom otherConnectingAtom, IBond.Order bondOrder, int hydrogenCount) {
        IAtom newAtom = this.currentMolecule.getBuilder().newInstance(IAtom.class, newAtomType);
        newAtom.setImplicitHydrogenCount(hydrogenCount);
        IBond newBond = this.currentMolecule.getBuilder().newInstance(IBond.class, new Object[]{newAtom, otherConnectingAtom, bondOrder});
        this.currentMolecule.addAtom(newAtom);
        this.currentMolecule.addBond(newBond);
    }

    private void addHeads(List<AttachedGroup> attachedSubstituents) {
        for (AttachedGroup attachedSubstituent : attachedSubstituents) {
            for (Token locationToken : attachedSubstituent.getLocations()) {
                int joinLocation = Integer.parseInt(locationToken.image) - 1;
                IAtom connectingAtom = joinLocation < 0 ? this.endOfChain : this.currentMolecule.getAtom(joinLocation);
                IAtomContainer subChain = this.buildChain(attachedSubstituent.getLength(), false);
                IBond linkingBond = this.currentMolecule.getBuilder().newInstance(IBond.class, subChain.getAtom(0), connectingAtom);
                this.currentMolecule.addBond(linkingBond);
                this.currentMolecule.add(subChain);
            }
        }
    }

    protected IAtomContainer buildMolecule(int mainChain, List<AttachedGroup> attachedSubstituents, List<AttachedGroup> attachedGroups, boolean isMainCyclic, String name) throws ParseException, CDKException {
        this.currentMolecule.setID(name);
        this.currentMolecule.add(this.buildChain(mainChain, isMainCyclic));
        if (mainChain != 0) {
            this.endOfChain = this.currentMolecule.getAtom(this.currentMolecule.getAtomCount() - 1);
        }
        this.buildFunGroups(attachedGroups);
        this.addHeads(attachedSubstituents);
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(this.currentMolecule.getBuilder());
        for (IAtom atom : this.currentMolecule.atoms()) {
            IAtomType type = matcher.findMatchingAtomType(this.currentMolecule, atom);
            AtomTypeManipulator.configure(atom, type);
        }
        CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance(this.currentMolecule.getBuilder());
        hAdder.addImplicitHydrogens(this.currentMolecule);
        return this.currentMolecule;
    }

    private static IAtomContainer makeBenzene() {
        AtomContainer mol = new AtomContainer();
        mol.addAtom(new Atom("C"));
        mol.addAtom(new Atom("C"));
        mol.addAtom(new Atom("C"));
        mol.addAtom(new Atom("C"));
        mol.addAtom(new Atom("C"));
        mol.addAtom(new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.DOUBLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.DOUBLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.DOUBLE);
        return mol;
    }

    private static IAtomContainer makeAlkane(int chainLength) {
        AtomContainer currentChain = new AtomContainer();
        currentChain.addAtom(new Atom("C"));
        for (int atomCount = 1; atomCount < chainLength; ++atomCount) {
            currentChain.addAtom(new Atom("C"));
            currentChain.addBond(atomCount, atomCount - 1, IBond.Order.SINGLE);
        }
        return currentChain;
    }
}

