/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff;

import com.qarks.util.files.diff.FileLine;
import com.qarks.util.files.diff.MergeResultItem;
import com.qarks.util.files.diff.ParsedFile;
import java.util.ArrayList;

public class MergeResult {
    private ArrayList<MergeResultItem> mergeItems;
    private ParsedFile leftFile = null;
    private ParsedFile rightFile = null;
    private String eol = System.getProperty("line.separator");

    public MergeResult(ArrayList<MergeResultItem> arrayList) {
        this.mergeItems = arrayList;
    }

    public ParsedFile getLeftFile() {
        if (this.leftFile == null) {
            ArrayList<FileLine> arrayList = new ArrayList<FileLine>();
            for (int i = 0; i < this.mergeItems.size(); ++i) {
                arrayList.addAll(this.mergeItems.get(i).getLeftVersion());
            }
            this.leftFile = new ParsedFile(arrayList);
        }
        return this.leftFile;
    }

    public ParsedFile getRightFile() {
        if (this.rightFile == null) {
            ArrayList<FileLine> arrayList = new ArrayList<FileLine>();
            for (int i = 0; i < this.mergeItems.size(); ++i) {
                arrayList.addAll(this.mergeItems.get(i).getRightVersion());
            }
            this.rightFile = new ParsedFile(arrayList);
        }
        return this.rightFile;
    }

    public ArrayList<MergeResultItem> getMergeItems() {
        return this.mergeItems;
    }

    public String getDefaultMergedResult() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mergeItems.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(this.eol);
            }
            MergeResultItem mergeResultItem = this.mergeItems.get(i);
            MergeResultItem.Type type = mergeResultItem.getType();
            String string = "";
            boolean bl = mergeResultItem.getDefaultVersion() == MergeResultItem.DefaultVersion.LEFT;
            String string2 = this.getText(mergeResultItem.getLeftVersion());
            String string3 = this.getText(mergeResultItem.getRightVersion());
            switch (type) {
                case NO_CONFLICT: {
                    string = bl ? string2 : string3;
                    break;
                }
                case CONFLICT: {
                    string = "<<CONFLICT>>";
                    break;
                }
                case WARNING_ORDER: {
                    string = string2 + this.eol + string3;
                    break;
                }
                case WARNING_DELETE: {
                    string = bl ? string2 : string3;
                }
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public boolean isConflict() {
        boolean bl = false;
        for (int i = 0; !bl && i < this.mergeItems.size(); ++i) {
            MergeResultItem mergeResultItem = this.mergeItems.get(i);
            if (mergeResultItem.getType() != MergeResultItem.Type.CONFLICT) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isWarning() {
        boolean bl = false;
        for (int i = 0; !bl && i < this.mergeItems.size(); ++i) {
            MergeResultItem mergeResultItem = this.mergeItems.get(i);
            if (mergeResultItem.getType() != MergeResultItem.Type.WARNING_DELETE && mergeResultItem.getType() != MergeResultItem.Type.WARNING_ORDER) continue;
            bl = true;
        }
        return bl;
    }

    private String getText(ArrayList<FileLine> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(this.eol);
            }
            stringBuffer.append(arrayList.get(i).getContent());
        }
        return stringBuffer.toString();
    }
}

