/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.propagation.event;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.event.PropagationEvent;
import choco.kernel.solver.variables.Var;

public abstract class VarEvent<E extends Var>
implements PropagationEvent {
    public static final int NOEVENT = -2;
    public static final int NOCAUSE = -1;
    public static final int DOWDCAUSE = Integer.MIN_VALUE;
    protected SConstraint cause = null;
    public static final int EMPTYEVENT = 0;
    protected E modifiedVar;
    protected int eventType = 0;
    protected int propagatedEvents = 0;

    public VarEvent(E var) {
        this.modifiedVar = var;
    }

    public final void addPropagatedEvents(int bitsmask) {
        this.propagatedEvents |= bitsmask;
    }

    public final int getPropagatedEvents() {
        return this.propagatedEvents;
    }

    public final E getModifiedVar() {
        return this.modifiedVar;
    }

    @Override
    public final Object getModifiedObject() {
        return this.modifiedVar;
    }

    protected void freeze() {
        this.cause = null;
    }

    protected boolean release() {
        return this.cause != null;
    }

    @Override
    public abstract boolean propagateEvent() throws ContradictionException;

    @Override
    public abstract void clear();

    @Override
    public final boolean isActive(int idx) {
        return true;
    }

    public final SConstraint getCause() {
        return this.cause;
    }

    @Override
    public int getPriority() {
        return this.modifiedVar.getPriority();
    }

    public final int getEventType() {
        return this.eventType;
    }

    @Deprecated
    public static int domOverWDegIdx(int idx) {
        return Integer.MIN_VALUE + idx;
    }

    @Deprecated
    public static int domOverWDegInitialIdx(int idx) {
        return idx - Integer.MIN_VALUE;
    }

    public final boolean isEnqueued() {
        return this.eventType != 0;
    }

    public void recordEventTypeAndCause(int basicEvt, SConstraint constraint, boolean forceAwake) {
        if (this.eventType == 0) {
            assert (this.cause == null || this.eventType == 0);
            this.eventType = 1 << basicEvt;
            if (!forceAwake) {
                this.cause = constraint;
            }
        } else {
            this.eventType |= 1 << basicEvt;
            if (this.cause != constraint) {
                this.cause = null;
            }
        }
    }
}

