/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.simprocs.InterpretedThread;
import umontreal.iro.lecuyer.simprocs.ProcessSimulator;
import umontreal.iro.lecuyer.simprocs.ResumeEvent;
import umontreal.iro.lecuyer.simprocs.SimProcess;

public class DSOLProcessSimulator
extends ProcessSimulator {
    public void init() {
        super.init();
    }

    public void init(EventList evlist) {
        super.init(evlist);
    }

    public ResumeEvent createControlEvent(SimProcess process) {
        return new ResumeEvent(this, new InterpretedThread(process));
    }

    public void delay(SimProcess process, double delay) {
        if (process.scheduledEvent() == null) {
            throw new IllegalStateException("Calling delay() for a dead process");
        }
        if (this.currentProcess != process) {
            throw new IllegalStateException("Calling delay() for a process not in EXECUTING state");
        }
        if (delay < 0.0) {
            throw new IllegalArgumentException("Calling delay() with negative delay");
        }
        process.scheduledEvent().schedule(delay);
        process.suspend();
    }

    public void suspend(SimProcess process) {
        if (process.scheduledEvent() == null) {
            throw new IllegalStateException("Calling suspend() for a dead process");
        }
        if (this.currentProcess == process) {
            ((ResumeEvent)process.scheduledEvent()).target().suspend();
            return;
        }
        if (process.scheduledEvent().time() >= 0.0) {
            process.scheduledEvent().cancel();
            process.scheduledEvent().setTime(-10.0);
            return;
        }
        if (process.scheduledEvent().time() == -20.0) {
            throw new IllegalStateException("Calling suspend() for a process in INITIAL state");
        }
        throw new IllegalStateException("Calling suspend() for a suspended process");
    }

    public void kill(SimProcess process) {
        if (process.scheduledEvent() == null) {
            throw new IllegalStateException("Calling kill() on a DEAD process");
        }
        if (this.currentProcess == process) {
            process.setScheduledEvent(null);
            InterpretedThread pr = ((ResumeEvent)process.scheduledEvent()).target();
            ((ResumeEvent)process.scheduledEvent()).setTarget(null);
            pr.suspend();
            return;
        }
        if (process.scheduledEvent().time() >= 0.0) {
            process.scheduledEvent().cancel();
        }
        process.setScheduledEvent(null);
        ((ResumeEvent)process.scheduledEvent()).setTarget(null);
    }

    public void killAll() {
    }
}

