/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data.pojo;

import uno.informatics.data.Feature;
import uno.informatics.data.Method;
import uno.informatics.data.pojo.EntityPojo;
import uno.informatics.data.pojo.MethodPojo;

public class FeaturePojo
extends EntityPojo
implements Feature {
    private static final long serialVersionUID = 1L;
    public static final String METHOD_PROPERTY = Feature.class.getName() + ".method";
    private MethodPojo method;

    protected FeaturePojo(String name) {
        super(name);
    }

    protected FeaturePojo(String uniqueIdentifier, String name) {
        super(uniqueIdentifier, name);
    }

    protected FeaturePojo(String uniqueIdentifier, String name, String description) {
        super(uniqueIdentifier, name, description);
    }

    public FeaturePojo(String name, MethodPojo method) {
        super(name);
        this.setMethod(method);
    }

    public FeaturePojo(String uniqueIdentifier, String name, MethodPojo method) {
        super(uniqueIdentifier, name);
        this.setMethod(method);
    }

    public FeaturePojo(String uniqueIdentifier, String name, String description, MethodPojo method) {
        super(uniqueIdentifier, name, description);
        this.setMethod(method);
    }

    public FeaturePojo(Feature feature) {
        super(feature);
        if (feature == null) {
            throw new IllegalArgumentException("Feature is not optional!");
        }
        this.setMethod(new MethodPojo(feature.getMethod()));
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Method is not optional for feature!");
        }
        MethodPojo oldValue = this.method;
        this.method = new MethodPojo(method);
        this.getPropertyChangeSupport().firePropertyChange(METHOD_PROPERTY, oldValue, this.method);
    }
}

