/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.datagenerators.DataGenerator;
import weka.datagenerators.classifiers.classification.RDG1;
import weka.gui.GenericObjectEditor;
import weka.gui.Logger;
import weka.gui.PropertyPanel;
import weka.gui.SysErrLog;

public class DataGeneratorPanel
extends JPanel {
    private static final long serialVersionUID = -2520408165350629380L;
    protected GenericObjectEditor m_GeneratorEditor = new GenericObjectEditor();
    protected Instances m_Instances = null;
    protected StringWriter m_Output = new StringWriter();
    protected Logger m_Log = new SysErrLog();

    public DataGeneratorPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)new PropertyPanel((PropertyEditor)this.m_GeneratorEditor), "Center");
        this.m_GeneratorEditor.setClassType(DataGenerator.class);
        this.m_GeneratorEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                DataGeneratorPanel.this.repaint();
            }
        });
        this.setGenerator(null);
    }

    public void setLog(Logger value) {
        this.m_Log = value;
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public String getOutput() {
        return this.m_Output.toString();
    }

    public void setGenerator(DataGenerator value) {
        if (value != null) {
            this.m_GeneratorEditor.setValue(value);
        } else {
            this.m_GeneratorEditor.setValue(new RDG1());
        }
    }

    public DataGenerator getGenerator() {
        return (DataGenerator)this.m_GeneratorEditor.getValue();
    }

    public boolean execute() {
        boolean result = true;
        DataGenerator generator = (DataGenerator)this.m_GeneratorEditor.getValue();
        String relName = generator.getRelationName();
        String cname = generator.getClass().getName().replaceAll(".*\\.", "");
        String cmd = generator.getClass().getName();
        if (generator instanceof OptionHandler) {
            cmd = cmd + " " + Utils.joinOptions(generator.getOptions());
        }
        try {
            this.m_Log.logMessage("Started " + cname);
            this.m_Log.logMessage("Command: " + cmd);
            this.m_Output = new StringWriter();
            generator.setOutput(new PrintWriter(this.m_Output));
            DataGenerator.makeData(generator, generator.getOptions());
            this.m_Instances = new Instances(new StringReader(this.getOutput()));
            this.m_Log.logMessage("Finished " + cname);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error generating data:\n" + e.getMessage(), "Error", 0);
            this.m_Instances = null;
            this.m_Output = new StringWriter();
            result = false;
        }
        generator.setRelationName(relName);
        return result;
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

