/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import java.util.List;

public class TsVariableSelection<T extends ITsVariable> {
    private ArrayList<Item<T>> m_regs = new ArrayList();

    public boolean isEmpty() {
        return this.m_regs.isEmpty();
    }

    public void add(T item, int pos) {
        this.m_regs.add(new Item<T>(item, pos));
    }

    public void clear() {
        this.m_regs.clear();
    }

    public List<DataBlock> data(TsDomain domain) {
        ArrayList<DataBlock> cols = new ArrayList<DataBlock>();
        int cur = 0;
        for (Item<T> group : this.m_regs) {
            int dim = group.variable.getDim();
            for (int i = 0; i < dim; ++i) {
                cols.add(new DataBlock(domain.getLength()));
            }
            group.variable.data(domain, cols.subList(cur, cur + dim));
            cur += dim;
        }
        return cols;
    }

    public Item<T>[] elements() {
        return Jdk6.Collections.toArray(this.m_regs, Item.class);
    }

    public Item<T> get(int idx) {
        return this.m_regs.get(idx);
    }

    public int getItemsCount() {
        return this.m_regs.size();
    }

    public int[] getPositions() {
        int[] pos = new int[this.getVariablesCount()];
        int cur = 0;
        for (Item<T> var : this.m_regs) {
            for (int j = 0; j < var.variable.getDim(); ++j) {
                pos[cur++] = var.position + j;
            }
        }
        return pos;
    }

    public int getVariablesCount() {
        int n = 0;
        for (Item<T> var : this.m_regs) {
            n += var.variable.getDim();
        }
        return n;
    }

    public Matrix matrix(TsDomain domain) {
        int ncols = this.getVariablesCount();
        int nrows = domain.getLength();
        Matrix m = new Matrix(nrows, ncols);
        ArrayList<DataBlock> cols = new ArrayList<DataBlock>();
        for (int i = 0; i < ncols; ++i) {
            cols.add(m.column(i));
        }
        int cur = 0;
        for (Item<T> group : this.m_regs) {
            int dim = group.variable.getDim();
            group.variable.data(domain, cols.subList(cur, cur + dim));
            cur += dim;
        }
        return m;
    }

    public DataBlock sum(DataBlock coeffs, TsDomain domain) {
        if (this.m_regs.isEmpty()) {
            return null;
        }
        DataBlock rslt = new DataBlock(domain.getLength());
        for (Item<T> group : this.m_regs) {
            int i;
            ArrayList<DataBlock> data = new ArrayList<DataBlock>();
            int dim = group.variable.getDim();
            for (i = 0; i < dim; ++i) {
                data.add(new DataBlock(domain.getLength()));
            }
            group.variable.data(domain, data);
            for (i = 0; i < dim; ++i) {
                rslt.addAY(coeffs.get(group.position + i), data.get(i));
            }
        }
        return rslt;
    }

    public static class Item<T extends ITsVariable> {
        public final T variable;
        public final int position;

        public Item(T item, int pos) {
            this.variable = item;
            this.position = pos;
        }
    }
}

