/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.satoolkit.seats.IModelApproximator;
import ec.satoolkit.seats.SeatsContext;
import ec.satoolkit.seats.SeatsModel;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;

public class DefaultModelApproximator3
implements IModelApproximator {
    private static final double DEF_RMODP = 0.7;
    private double rmodp_ = 0.7;
    private int difsOrig_;

    private boolean estimateModel(boolean ml, SeatsModel model, InformationSet info, SeatsContext context) {
        if (context.getEstimator().estimate(ml, model, info)) {
            this.addInformation(model, context);
            return true;
        }
        return false;
    }

    private void addInformation(SeatsModel model, SeatsContext context) {
    }

    @Override
    public boolean approximate(SeatsModel sm, InformationSet info, SeatsContext context) {
        if (this.difsOrig_ == -1) {
            SarimaSpecification spec = sm.getSarima().getSpecification();
            this.difsOrig_ = spec.getD() + spec.getBD();
        }
        if (this.app_known(sm, info, context)) {
            return true;
        }
        if (this.app_seas(sm, info, context)) {
            return true;
        }
        if (this.app_redp(sm, info, context)) {
            return true;
        }
        if (this.app_redq(sm, info, context)) {
            return true;
        }
        return this.app_last(sm, info, context);
    }

    private boolean app_seas(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        boolean mean = sm.isMeanCorrection();
        int p = spec.getP();
        int d = spec.getD();
        int q = spec.getQ();
        int bp = spec.getBP();
        int bd = spec.getBD();
        int bq = spec.getBQ();
        if (bd == 1 && bp == 1) {
            spec.setBP(0);
            spec.setBQ(1);
        } else if (bd == 0 && bq == 1) {
            double bth = cur.btheta(1);
            if (bp == 0) {
                if (bth > 0.0) {
                    spec.setBP(1);
                }
                spec.setBQ(0);
            } else {
                double bphi = cur.bphi(1);
                if (bphi < -this.rmodp_ && bth > 0.0) {
                    spec.setBD(1);
                    spec.setBP(0);
                    mean = false;
                } else {
                    spec.setBQ(0);
                }
            }
        } else if (bp == 1 && bd == 0 && bq == 0) {
            if (p == 0 && d == 1 && q > 1) {
                spec.setQ(q - 1);
            } else if (cur.bphi(1) < -0.3 && sm.hasSignificantSeasonality()) {
                spec.setBP(0);
                spec.setBD(1);
                spec.setBQ(1);
                mean = false;
            } else {
                spec.setBP(0);
            }
        } else {
            return false;
        }
        sm.setModelSpecification(spec);
        sm.setMeanCorrection(mean);
        return this.estimateModel(true, sm, info, context);
    }

    private boolean app_redp(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        if (spec.getP() == 0) {
            return false;
        }
        double rdroot = 0.0;
        Complex[] proots = cur.getRegularAR().roots();
        for (int i = 0; i < proots.length; ++i) {
            double re = proots[i].getRe();
            double im = proots[i].getIm();
            if (im != 0.0 || !(re > 0.0) || !((re = 1.0 / re) > rdroot)) continue;
            rdroot = re;
        }
        spec.setP(spec.getP() - 1);
        if (rdroot > 0.5) {
            spec.setD(Math.min(spec.getD() + 1, 2));
            if (spec.getBD() + spec.getD() > this.difsOrig_) {
                sm.setMeanCorrection(false);
            }
        }
        int q = spec.getQ();
        q = Math.min(q + 1, spec.getD() + spec.getP());
        spec.setQ(Math.min(q, 3));
        sm.setModelSpecification(spec);
        return this.estimateModel(true, sm, info, context);
    }

    private boolean app_redq(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        if (spec.getQ() == 1) {
            return false;
        }
        spec.setQ(Math.max(spec.getQ() - 1, 1));
        sm.setModelSpecification(spec);
        return this.estimateModel(true, sm, info, context);
    }

    private boolean app_last(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        spec.setBQ(0);
        sm.setModelSpecification(spec);
        return this.estimateModel(true, sm, info, context);
    }

    @Override
    public boolean pretest(SeatsModel sm, InformationSet info, SeatsContext context) {
        return true;
    }

    @Override
    public void startApproximation() {
        this.difsOrig_ = -1;
    }

    private boolean app_known(SeatsModel sm, InformationSet info, SeatsContext context) {
        SarimaModel cur = sm.getSarima();
        SarimaSpecification spec = cur.getSpecification();
        int p = spec.getP();
        int d = spec.getD();
        int q = spec.getQ();
        int bp = spec.getBP();
        int bd = spec.getBD();
        int bq = spec.getBQ();
        if (bp != 0 || bd != 1 || q > 1 || p != 0) {
            return false;
        }
        switch (d) {
            case 0: {
                return this.app_001011(sm, cur, spec, context);
            }
            case 2: {
                return this.app_021011(sm, cur, spec, context);
            }
        }
        return this.app_011011(sm, cur, spec, context);
    }

    private boolean app_001011(SeatsModel sm, SarimaModel cur, SarimaSpecification spec, SeatsContext context) {
        cur.setBTheta(1, 0.0);
        cur.adjustSpecification();
        sm.setModel(cur);
        this.addInformation(sm, context);
        return true;
    }

    private boolean app_011011(SeatsModel sm, SarimaModel cur, SarimaSpecification spec, SeatsContext context) {
        double bth;
        double th = spec.getQ() == 1 ? -cur.theta(1) : 0.0;
        switch (spec.getFrequency()) {
            case 12: {
                if (th > 0.36 && th < 0.7) {
                    bth = 0.2;
                    break;
                }
                bth = 0.1;
                break;
            }
            case 4: {
                if (th < 0.2 && th >= 0.0) {
                    bth = -0.3;
                    break;
                }
                if (th < 0.0 && th > -0.2) {
                    bth = -0.24;
                    break;
                }
                if (Math.abs(th) > 0.4) {
                    bth = -0.1;
                    break;
                }
                bth = -0.2;
                break;
            }
            default: {
                bth = 0.0;
            }
        }
        spec.setQ(th == 0.0 ? 0 : 1);
        spec.setBQ(bth == 0.0 ? 0 : 1);
        SarimaModel ncur = new SarimaModel(spec);
        if (th != 0.0) {
            ncur.setTheta(1, -th);
        }
        if (bth != 0.0) {
            ncur.setBTheta(1, -bth);
        }
        sm.setModel(ncur);
        this.addInformation(sm, context);
        return true;
    }

    private boolean app_021011(SeatsModel sm, SarimaModel cur, SarimaSpecification spec, SeatsContext context) {
        double th = spec.getQ() == 1 ? -cur.theta(1) : 0.0;
        double bth = spec.getBQ() == 1 ? -cur.btheta(1) : 0.0;
        switch (spec.getFrequency()) {
            case 12: {
                if (th < -0.4) {
                    th = -0.5;
                    bth = 0.9;
                    break;
                }
                if (th < 0.25) {
                    bth = (4.95 - 4.0 * th) / 7.0;
                    break;
                }
                if (th < 0.55) {
                    if (bth >= -0.3) {
                        bth = -3.2 * th + 1.55;
                        break;
                    }
                    th = 0.55;
                    bth = -0.3;
                    break;
                }
                bth = (th - 1.15) / 2.0;
                break;
            }
            case 4: {
                if (th >= -0.4) {
                    bth = -0.3;
                    break;
                }
                if (bth < -0.3) {
                    th = -0.4;
                    bth = -0.3;
                    break;
                }
                th = -0.45 * bth - 0.535;
                break;
            }
            case 6: {
                if (th >= 0.1) {
                    bth = -0.2;
                    break;
                }
                if (bth < -0.3) {
                    bth = -0.3;
                    th = 0.1;
                    break;
                }
                if (th > -0.3) {
                    bth = -1.5 * th - 0.05;
                    break;
                }
                if (th >= -0.9) {
                    bth = -th - 0.05;
                    break;
                }
                bth = 0.95;
                th = -0.9;
                break;
            }
            case 3: {
                if (th > 0.55) {
                    bth = -0.1;
                    break;
                }
                if (bth < -0.3) {
                    th = 0.55;
                    bth = -0.3;
                    break;
                }
                if (th > -0.4) {
                    if (bth < 0.0) {
                        th = 0.55;
                        break;
                    }
                    if (bth < 0.7) {
                        th = -0.5 * bth + 0.55;
                        break;
                    }
                    th = -3.21 * bth + 2.45;
                    break;
                }
                if (th > -0.7) {
                    bth = 0.95;
                    break;
                }
                bth = 0.95;
                th = -0.7;
                break;
            }
            case 2: {
                bth = th >= 0.4 ? -0.3 : 0.48 * th - 0.49;
            }
        }
        boolean hasq = Math.abs(th) > 1.0E-10;
        boolean hasbq = Math.abs(bth) > 1.0E-10;
        spec.setQ(hasq ? 1 : 0);
        spec.setBQ(hasbq ? 1 : 0);
        SarimaModel ncur = new SarimaModel(spec);
        if (hasq) {
            ncur.setTheta(1, -th);
        }
        if (hasbq) {
            ncur.setBTheta(1, -bth);
        }
        sm.setModel(ncur);
        this.addInformation(sm, context);
        return true;
    }
}

