/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.SecurityConfiguration;
import java.util.Date;

@SdkInternalApi
public class SecurityConfigurationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Date> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimeStamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionConfiguration").build();
    private static final SecurityConfigurationMarshaller instance = new SecurityConfigurationMarshaller();

    public static SecurityConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SecurityConfiguration securityConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (securityConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(securityConfiguration.getName(), NAME_BINDING);
            protocolMarshaller.marshall(securityConfiguration.getCreatedTimeStamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall(securityConfiguration.getEncryptionConfiguration(), ENCRYPTIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

