/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.monitoring;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.monitoring.CsmConfiguration;
import com.simba.athena.amazonaws.monitoring.CsmConfigurationProvider;
import com.simba.athena.shaded.apache.commons.logging.Log;
import com.simba.athena.shaded.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CsmConfigurationProviderChain
implements CsmConfigurationProvider {
    private static final Log log = LogFactory.getLog(CsmConfigurationProviderChain.class);
    private final List<CsmConfigurationProvider> providers = new ArrayList<CsmConfigurationProvider>();

    public CsmConfigurationProviderChain(CsmConfigurationProvider ... providers) {
        if (providers != null) {
            Collections.addAll(this.providers, providers);
        }
    }

    @Override
    public CsmConfiguration getConfiguration() {
        for (CsmConfigurationProvider p : this.providers) {
            try {
                return p.getConfiguration();
            }
            catch (SdkClientException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Unable to load configuration from " + p.toString() + ": " + e.getMessage());
            }
        }
        throw new SdkClientException("Could not resolve client side monitoring configuration from the configured providers in the chain");
    }
}

