/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.conditionaltests;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import moa.classifiers.core.conditionaltests.InstanceConditionalBinaryTest;

public class NumericAttributeBinaryTest
extends InstanceConditionalBinaryTest {
    private static final long serialVersionUID = 1L;
    protected int attIndex;
    protected double attValue;
    protected boolean equalsPassesTest;

    public NumericAttributeBinaryTest(int attIndex, double attValue, boolean equalsPassesTest) {
        this.attIndex = attIndex;
        this.attValue = attValue;
        this.equalsPassesTest = equalsPassesTest;
    }

    @Override
    public int branchForInstance(Instance inst) {
        int instAttIndex = this.attIndex;
        if (inst.isMissing(instAttIndex)) {
            return -1;
        }
        double v = inst.valueInputAttribute(instAttIndex);
        if (v == this.attValue) {
            return this.equalsPassesTest ? 0 : 1;
        }
        return v < this.attValue ? 0 : 1;
    }

    @Override
    public String describeConditionForBranch(int branch, InstancesHeader context) {
        if (branch == 0 || branch == 1) {
            char compareChar = branch == 0 ? (char)'<' : '>';
            int equalsBranch = this.equalsPassesTest ? 0 : 1;
            return InstancesHeader.getInputAttributeNameString(context, this.attIndex) + ' ' + compareChar + (branch == equalsBranch ? "= " : " ") + InstancesHeader.getNumericValueString(context, this.attIndex, this.attValue);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    public int[] getAttsTestDependsOn() {
        return new int[]{this.attIndex};
    }

    public double getSplitValue() {
        return this.attValue;
    }
}

