/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class IncreasingSum
extends AbstractLargeIntSConstraint {
    IntDomainVar[] dec;
    int n;
    IntDomainVar s;

    protected static IntDomainVar[] buildVars(IntDomainVar[] dec, IntDomainVar s) {
        IntDomainVar[] res = new IntDomainVar[dec.length + 1];
        System.arraycopy(dec, 0, res, 0, dec.length);
        res[dec.length] = s;
        return res;
    }

    public IncreasingSum(IntDomainVar[] dec, IntDomainVar s) {
        super(IncreasingSum.buildVars(dec, s));
        this.dec = dec;
        this.s = s;
        this.n = dec.length;
    }

    public void updateMin() throws ContradictionException {
        int minSum = this.dec[0].getInf();
        for (int i = 1; i < this.n; ++i) {
            if (this.dec[i - 1].getInf() > this.dec[i].getInf()) {
                this.dec[i].updateInf(this.dec[i - 1].getInf(), this, false);
            }
            minSum += this.dec[i].getInf();
        }
        if (minSum > this.s.getInf()) {
            this.s.updateInf(minSum, this, false);
        }
    }

    public void updateMax() throws ContradictionException {
        int maxSum = this.dec[this.n - 1].getSup();
        for (int i = this.n - 2; i >= 0; --i) {
            if (this.dec[i + 1].getSup() < this.dec[i].getSup()) {
                this.dec[i].updateSup(this.dec[i + 1].getSup(), this, false);
            }
            maxSum += this.dec[i].getSup();
        }
        if (maxSum < this.s.getSup()) {
            this.s.updateSup(maxSum, this, false);
        }
    }

    public void filterMax() throws ContradictionException {
        int i;
        int minSum = 0;
        for (int i2 = 0; i2 < this.n; ++i2) {
            minSum += this.dec[i2].getInf();
        }
        int margin = this.s.getSup() - minSum;
        int j = i = this.n - 1;
        int delta_i = this.dec[i].getSup() - this.dec[i].getInf();
        while (i >= 0) {
            if (delta_i <= margin) {
                int oldmax = this.dec[i].getSup();
                if (--i >= 0) {
                    while (this.dec[j].getInf() >= this.dec[i].getSup() && j > i) {
                        delta_i -= oldmax - this.dec[j].getInf();
                        --j;
                    }
                    delta_i += this.dec[i].getSup() - this.dec[i].getInf() - (j - i) * (oldmax - this.dec[i].getSup());
                }
            } else {
                while (delta_i > margin) {
                    int cut = (delta_i - margin) / (j - i + 1);
                    if ((delta_i - margin) % (j - i + 1) > 0) {
                        ++cut;
                    }
                    int steps = Math.min(cut, this.dec[i].getSup() - this.dec[j].getInf());
                    this.dec[i].setSup(this.dec[i].getSup() - steps);
                    delta_i -= (j - i + 1) * steps;
                    while (this.dec[j].getInf() >= this.dec[i].getSup() && j > i) {
                        --j;
                    }
                }
            }
            if (i <= 0 || this.dec[i - 1].getSup() <= this.dec[i].getSup()) continue;
            this.dec[i - 1].setSup(this.dec[i].getSup());
        }
    }

    public void filterMin() throws ContradictionException {
        int i;
        int maxSum = 0;
        for (int i2 = 0; i2 < this.n; ++i2) {
            maxSum += this.dec[i2].getSup();
        }
        int margin = this.s.getInf() - maxSum;
        int j = i = 0;
        int delta_i = this.dec[i].getInf() - this.dec[i].getSup();
        while (i < this.n) {
            if (delta_i >= margin) {
                int oldmin = this.dec[i].getInf();
                if (++i < this.n) {
                    while (this.dec[j].getSup() <= this.dec[i].getInf() && j < i) {
                        delta_i += this.dec[j].getSup() - oldmin;
                        ++j;
                    }
                    delta_i -= this.dec[i].getSup() - this.dec[i].getInf() + (i - j) * (oldmin - this.dec[i].getInf());
                }
            } else {
                while (delta_i < margin) {
                    int cut = (margin - delta_i) / (i - j + 1);
                    if ((margin - delta_i) % (i - j + 1) > 0) {
                        ++cut;
                    }
                    int steps = Math.min(cut, this.dec[j].getSup() - this.dec[i].getInf());
                    this.dec[i].setInf(this.dec[i].getInf() + steps);
                    delta_i += (i - j + 1) * steps;
                    while (this.dec[j].getSup() <= this.dec[i].getInf() && j < i) {
                        ++j;
                    }
                }
            }
            if (i >= this.n - 1 || this.dec[i + 1].getInf() >= this.dec[i].getInf()) continue;
            this.dec[i + 1].setInf(this.dec[i].getInf());
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        this.updateMax();
        this.updateMin();
        this.filterMax();
        this.filterMin();
    }

    @Override
    public boolean isSatisfied() {
        if (this.isCompletelyInstantiated()) {
            int res = this.dec[0].getVal();
            for (int i = 1; i < this.dec.length; ++i) {
                if (this.dec[i - 1].getVal() > this.dec[i].getVal()) {
                    return false;
                }
                res += this.dec[i].getVal();
            }
            return res == this.s.getVal();
        }
        return false;
    }
}

