/*
 * Decompiled with CFR 0.152.
 */
package choco;

import choco.Choco;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.common.util.tools.VariableUtils;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.model.variables.set.SetVariable;

public class Reformulation {
    public static Constraint[] among(IntegerVariable[] variables, SetVariable s, IntegerVariable nvar) {
        IntegerExpressionVariable[] bools = new IntegerVariable[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            bools[i] = Choco.makeBooleanVar(StringUtils.randomName(), new String[0]);
        }
        Constraint[] cs = new Constraint[variables.length + 1];
        for (int i = 0; i < variables.length; ++i) {
            cs[i] = Choco.reifiedConstraint(bools[i], Choco.member(variables[i], s), Choco.notMember(variables[i], s));
        }
        cs[variables.length] = Choco.eq((IntegerExpressionVariable)nvar, Choco.sum(bools));
        return cs;
    }

    public static Constraint[] among(IntegerVariable nvar, IntegerVariable[] variables, int[] values) {
        IntegerExpressionVariable[] bools = new IntegerVariable[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            bools[i] = Choco.makeBooleanVar(StringUtils.randomName(), new String[0]);
        }
        Constraint[] cs = new Constraint[variables.length + 1];
        for (int j = 0; j < bools.length; ++j) {
            cs[j] = Choco.reifiedConstraint(bools[j], Choco.member(variables[j], values));
        }
        cs[variables.length] = Choco.eq(Choco.sum(bools), (IntegerExpressionVariable)nvar);
        return cs;
    }

    public static Constraint[] disjunctive(TaskVariable[] clique, String ... boolvarOptions) {
        int n = clique.length;
        Constraint[] cstr = new Constraint[n * (n - 1) / 2];
        int idx = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                cstr[idx++] = Choco.precedenceDisjoint(clique[i], clique[j], VariableUtils.createDirVariable(clique[i], clique[j], boolvarOptions));
            }
        }
        return cstr;
    }
}

