## ----echo=FALSE, include=FALSE--------------------------------------------------------------------------------------
opts_chunk$set(opts_fig_wide)
opts_knit$set(concordance=TRUE)
opts_knit$set(unnamed.chunk.label = 'functions-chunk')


## ----fun-00---------------------------------------------------------------------------------------------------------
my.prod <- function(x, y){x * y}
my.prod(4, 3)


## ----fun-01---------------------------------------------------------------------------------------------------------
my.change <- function(x){x <- NA}
a <- 1
my.change(a)
a


## ----fun-02---------------------------------------------------------------------------------------------------------
print.x.1 <- function(x){print(x)}
print.x.1("test")
print.x.2 <- function(x){print(x); return(x)}
print.x.2("test")
print.x.3 <- function(x){return(x); print(x)}
print.x.3("test")
print.x.4 <- function(x){return(); print(x)}
print.x.4("test")
print.x.5 <- function(x){x}
print.x.4("test")


## ----fun-03---------------------------------------------------------------------------------------------------------
SEM <- function(x){sqrt(var(x) / length(x))}


## ----fun-04---------------------------------------------------------------------------------------------------------
a <- c(1, 2, 3, -5)
a.na <- c(a, NA)
SEM(x = a)
SEM(a)
SEM(a.na)


## ----fun-05---------------------------------------------------------------------------------------------------------
sem <- function(x, na.omit = FALSE) {
 if (na.omit) {
   x <- na.omit(x)
 }
 sqrt(var(x)/length(x))
}


## ----fun-06---------------------------------------------------------------------------------------------------------
sem(x = a)
sem(x = a.na)
sem(x = a.na, na.omit = TRUE)


## ----fun-07---------------------------------------------------------------------------------------------------------
sem


## ----fun-08---------------------------------------------------------------------------------------------------------
lm


## ----fun-09---------------------------------------------------------------------------------------------------------
list


## ----oper-01--------------------------------------------------------------------------------------------------------
1 / 2
`/`(1 , 2)
`/`(e1 = 1 , e2 = 2)


## ----oper-02--------------------------------------------------------------------------------------------------------
`/`


## ----oper-EB01------------------------------------------------------------------------------------------------------
"%-mean%" <- function(e1, e2) {
  e1 - mean(e2)
}


## ----oper-EB02------------------------------------------------------------------------------------------------------
10:15 %-mean% 1:20


## ----oper-EB03------------------------------------------------------------------------------------------------------
`%-mean%`


## ----object-classes-00----------------------------------------------------------------------------------------------
mean


## ----object-classes-00a---------------------------------------------------------------------------------------------
methods(mean)


## ----object-classes-00b---------------------------------------------------------------------------------------------
methods(class = "list")


## ----explain-object-classes-01--------------------------------------------------------------------------------------
a <- 123
class(a)
class(a) <- c("myclass", class(a))
class(a)


## ----explain-object-classes-02--------------------------------------------------------------------------------------
print.myclass <- function(x) {
    sprintf("[myclass] %.0f", as.numeric(x))
}


## ----explain-object-classes-03--------------------------------------------------------------------------------------
print(a)
print(as.numeric(a))


## ----explain-object-classes-04--------------------------------------------------------------------------------------
my_print <- function (x, ...) {
   UseMethod("my_print", x)
 }

my_print.default <- function(x, ...) {
   print(class(x))
   print(x, ...)
}


## ----explain-object-classes-05--------------------------------------------------------------------------------------
my_print(123)
my_print("abc")


## ----explain-object-classes-06--------------------------------------------------------------------------------------
my_print.data.frame <- function(x, rows = 1:5, ...) {
   print(x[rows, ], ...)
   invisible(x)
}


## ----explain-object-classes-07--------------------------------------------------------------------------------------
my_print(cars)


## ----explain-object-classes-07a-------------------------------------------------------------------------------------
my_print(cars, 8:10)


## ----explain-object-classes-07b-------------------------------------------------------------------------------------
b <- my_print(cars)
str(b)
nrow(b) == nrow(cars) # was the whole data frame returned?


## ----scope-01-------------------------------------------------------------------------------------------------------
pi
pi <- "apple pie"
pi
rm(pi)
pi
exists("pi")


## ----scope-02-------------------------------------------------------------------------------------------------------
my.pie <- "raspberry pie"
my.pie
my.pie <- "apple pie"
my.pie
rm(my.pie)
exists("my.pie")

