/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.dialogs.VariableNameDialog;
import org.af.gMCP.gui.graph.Node;
import org.af.jhlir.call.RList;

public class PowerParameterPanel
extends JPanel
implements ActionListener {
    GridBagConstraints c = new GridBagConstraints();
    List<JTextField> tfl = new Vector<JTextField>();
    Vector<Node> nodes;
    CreateGraphGUI parent;
    JPanel panel = new JPanel();
    JButton newSetting = new JButton("Add setting");
    JButton loadRSetting = new JButton("Load settings from R");
    String setting;
    Double defaultValue;
    DecimalFormat f = new DecimalFormat("#0.###");

    public PowerParameterPanel(String setting, Double defaultValue, Vector<Node> nodes, CreateGraphGUI parent) {
        this.nodes = nodes;
        this.defaultValue = defaultValue;
        this.parent = parent;
        this.setting = setting;
        String cols = "5dlu, fill:min:grow, 5dlu, fill:min:grow, 5dlu";
        String rows = "5dlu, fill:min:grow, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.add((Component)new JScrollPane(this.getPanel()), cc.xyw(2, row, 3));
        this.add((Component)this.newSetting, cc.xy(2, row += 2));
        this.newSetting.addActionListener(this);
        this.add((Component)this.loadRSetting, cc.xy(4, row));
        this.loadRSetting.addActionListener(this);
    }

    public void removeTextFields() {
        this.panel.removeAll();
        this.tfl.clear();
    }

    public JPanel getPanel() {
        this.c.fill = 1;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.ipadx = 10;
        this.c.ipady = 10;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.panel.setLayout(new GridBagLayout());
        this.panel.add((Component)new JLabel("Setting " + (this.tfl.size() + 1)), this.c);
        ++this.c.gridx;
        JTextField tf = new JTextField("" + this.defaultVector());
        this.tfl.add(tf);
        this.panel.add((Component)tf, this.c);
        this.c.gridx = 0;
        ++this.c.gridy;
        return this.panel;
    }

    public void addRow() {
        this.panel.add((Component)new JLabel("Setting " + (this.tfl.size() + 1)), this.c);
        ++this.c.gridx;
        JTextField tf = new JTextField("" + this.defaultVector());
        this.tfl.add(tf);
        this.panel.add((Component)tf, this.c);
        this.revalidate();
        this.repaint();
        this.c.gridx = 0;
        ++this.c.gridy;
    }

    public String defaultVector() {
        String s = "c(";
        for (int i = 1; i < this.nodes.size(); ++i) {
            s = s + this.f.format(this.defaultValue) + ", ";
        }
        return s + this.f.format(this.defaultValue) + ")";
    }

    public String buildVector(double[] data) {
        String s = "c(";
        for (int i = 0; i < data.length - 1; ++i) {
            s = s + this.f.format(data[i]) + ", ";
        }
        return s + this.f.format(data[data.length - 1]) + ")";
    }

    public void loadRObject() {
        VariableNameDialog vnd = new VariableNameDialog(this.parent);
        try {
            RList pList = RControl.getR().eval(vnd.getName()).asRList();
            this.removeTextFields();
            this.c.gridx = 0;
            this.c.gridy = 0;
            for (int i = 0; i < pList.getLength(); ++i) {
                double[] data = pList.get(i).asRNumeric().getData();
                if (data.length != this.nodes.size()) {
                    JOptionPane.showMessageDialog(this.parent, "Number of hypotheses and values do not match.", "Number of hypotheses and values do not match", 0);
                    return;
                }
                JTextField tf = new JTextField(this.buildVector(data));
                this.tfl.add(tf);
                this.panel.add((Component)new JLabel("Setting " + (this.tfl.size() + 1)), this.c);
                ++this.c.gridx;
                this.panel.add((Component)tf, this.c);
                this.c.gridx = 0;
                ++this.c.gridy;
                this.panel.revalidate();
                this.panel.repaint();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error loading values from R:\n" + ex.getMessage() + "\n\nThe object to load should be a arbitrary long list and \neach element will correspond to a setting and should be a\nnumeric vector of length equal to the number of hypotheses.\nSamplesize example: list(setting1=c(10,10,10),setting2=c(20,20,20))", "Error loading values from R", 0);
        }
    }

    public String getRList() {
        String s = "list(";
        for (int i = 0; i < this.tfl.size() - 1; ++i) {
            s = s + this.tfl.get(i).getText() + ",";
        }
        s = s + this.tfl.get(this.tfl.size() - 1).getText() + ")";
        return s;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.newSetting) {
            this.addRow();
        }
        if (e.getSource() == this.loadRSetting) {
            this.loadRObject();
        }
    }
}

