## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  warning = FALSE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
#install.packages("SMAHP")

## -----------------------------------------------------------------------------
library(SMAHP)
# load example data
data("example_dat")

## -----------------------------------------------------------------------------
surv_dat <- example_dat$surv_dat
res <- SMAHP(example_dat$X, example_dat$M, example_dat$C, 
             time = surv_dat$time, status = surv_dat$status)

## -----------------------------------------------------------------------------
print(res$p_final_matrix)

## -----------------------------------------------------------------------------
print(res$p_adjusted_matrix)

## -----------------------------------------------------------------------------
print(res$p_med_matrix)

## -----------------------------------------------------------------------------
get_sig_pathway(res_SMAHP = res)

## -----------------------------------------------------------------------------
get_coef(res_SMAHP = res)

