/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Transformations.CleanAttributes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class CleanAttributes {
    int[] exp;
    double tempData = 0.0;
    double new_min;
    double new_max;
    String[][] X = null;
    int ndatos = 0;
    int nentradas = 0;
    int tipo = 0;
    int direccion = 0;
    int nvariables = 0;
    int nsalidas = 0;
    InstanceSet IS;
    String input_train_name = new String();
    String input_test_name = new String();
    String output_train_name = new String();
    String output_test_name = new String();
    String temp = new String();
    String data_out = new String("");

    public CleanAttributes(String fileParam) {
        this.config_read(fileParam);
        this.IS = new InstanceSet();
    }

    public void applyClean() {
        Attribute a;
        int j;
        Instance inst;
        int i;
        int out;
        int in;
        try {
            this.IS.readSet(this.input_train_name, true);
            in = 0;
            out = 0;
            this.ndatos = this.IS.getNumInstances();
            this.nvariables = Attributes.getNumAttributes();
            this.nentradas = Attributes.getInputNumAttributes();
            this.nsalidas = Attributes.getOutputNumAttributes();
            this.X = new String[this.ndatos][this.nvariables];
            for (i = 0; i < this.ndatos; ++i) {
                inst = this.IS.getInstance(i);
                in = 0;
                out = 0;
                for (j = 0; j < this.nvariables; ++j) {
                    a = Attributes.getAttribute(j);
                    this.direccion = a.getDirectionAttribute();
                    this.tipo = a.getType();
                    if (this.usefulAttribute(a)) {
                        if (this.direccion == 1) {
                            this.X[i][j] = this.tipo != 0 && !inst.getInputMissingValues(in) ? new String(String.valueOf(inst.getInputRealValues(in))) : (!inst.getInputMissingValues(in) ? inst.getInputNominalValues(in) : new String("?"));
                        } else if (this.direccion == 2) {
                            this.X[i][j] = this.tipo != 0 && !inst.getOutputMissingValues(out) ? new String(String.valueOf(inst.getOutputRealValues(out))) : (!inst.getOutputMissingValues(out) ? inst.getOutputNominalValues(out) : new String("?"));
                        }
                    }
                    if (this.direccion == 1) {
                        ++in;
                        continue;
                    }
                    if (this.direccion != 2) continue;
                    ++out;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Dataset exception = " + e);
            System.exit(-1);
        }
        this.write_results(this.output_train_name);
        if (this.input_train_name.compareTo(this.input_test_name) != 0) {
            try {
                Attributes.clearAll();
                this.IS.readSet(this.input_test_name, true);
                in = 0;
                out = 0;
                this.ndatos = this.IS.getNumInstances();
                this.nvariables = Attributes.getNumAttributes();
                this.nentradas = Attributes.getInputNumAttributes();
                this.nsalidas = Attributes.getOutputNumAttributes();
                this.X = new String[this.ndatos][this.nvariables];
                for (i = 0; i < this.ndatos; ++i) {
                    inst = this.IS.getInstance(i);
                    in = 0;
                    out = 0;
                    for (j = 0; j < this.nvariables; ++j) {
                        a = Attributes.getAttribute(j);
                        this.direccion = a.getDirectionAttribute();
                        this.tipo = a.getType();
                        if (this.usefulAttribute(a)) {
                            if (this.direccion == 1) {
                                this.X[i][j] = this.tipo != 0 && !inst.getInputMissingValues(in) ? new String(String.valueOf(inst.getInputRealValues(in))) : (!inst.getInputMissingValues(in) ? inst.getInputNominalValues(in) : new String("?"));
                            } else if (this.direccion == 2) {
                                this.X[i][j] = this.tipo != 0 && !inst.getOutputMissingValues(out) ? new String(String.valueOf(inst.getOutputRealValues(out))) : (!inst.getOutputMissingValues(out) ? inst.getOutputNominalValues(out) : new String("?"));
                            }
                        }
                        if (this.direccion == 1) {
                            ++in;
                            continue;
                        }
                        if (this.direccion != 2) continue;
                        ++out;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Dataset exception = " + e);
                System.exit(-1);
            }
            this.write_results(this.output_test_name);
        }
    }

    private void config_read(String fileParam) {
        File inputFile = new File(fileParam);
        if (inputFile == null || !inputFile.exists()) {
            System.out.println("parameter " + fileParam + " file doesn't exists!");
            System.exit(-1);
        }
        try {
            String line;
            FileReader file_reader = new FileReader(inputFile);
            BufferedReader buf_reader = new BufferedReader(file_reader);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            String[] out = line.split("algorithm = ");
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("inputData = ");
            out = out[1].split("\\s\"");
            this.input_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.input_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.input_test_name.charAt(this.input_test_name.length() - 1) == '\"') {
                this.input_test_name = this.input_test_name.substring(0, this.input_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("outputData = ");
            out = out[1].split("\\s\"");
            this.output_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.output_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.output_test_name.charAt(this.output_test_name.length() - 1) == '\"') {
                this.output_test_name = this.output_test_name.substring(0, this.output_test_name.length() - 1);
            }
            file_reader.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }

    private void write_results(String output) {
        Attribute a;
        int i;
        String header = "";
        int outputDel = 0;
        int inputDel = 0;
        for (i = 0; i < Attributes.getNumAttributes(); ++i) {
            a = Attributes.getAttribute(i);
            if (a.getDirectionAttribute() == 1 && !this.usefulAttribute(a)) {
                Attributes.removeAttribute(true, i - inputDel);
                ++inputDel;
            }
            if (a.getDirectionAttribute() != 2 || this.usefulAttribute(a)) continue;
            Attributes.removeAttribute(false, i - outputDel);
            ++outputDel;
        }
        try {
            int j;
            FileWriter file_write = new FileWriter(output);
            header = header + "@relation " + Attributes.getRelationName() + "\n";
            for (i = 0; i < Attributes.getNumAttributes(); ++i) {
                a = Attributes.getAttribute(i);
                if (!this.usefulAttribute(a)) continue;
                if (a.getDirectionAttribute() == 1) {
                    header = header + "@attribute " + a.getName() + " ";
                    if (a.getType() == 0) {
                        header = header + "{";
                        for (j = 0; j < a.getNominalValuesList().size(); ++j) {
                            header = header + (String)a.getNominalValuesList().elementAt(j);
                            if (j >= a.getNominalValuesList().size() - 1) continue;
                            header = header + ", ";
                        }
                        header = header + "}\n";
                        continue;
                    }
                    if (a.getType() == 1) {
                        header = header + "integer";
                        header = header + " [" + String.valueOf((int)a.getMinAttribute()) + ", " + String.valueOf((int)a.getMaxAttribute()) + "]\n";
                        continue;
                    }
                    header = header + "real";
                    header = header + " [" + String.valueOf(a.getMinAttribute()) + ", " + String.valueOf(a.getMaxAttribute()) + "]\n";
                    continue;
                }
                header = header + "@attribute " + a.getName() + " ";
                if (a.getType() == 0) {
                    header = header + "{";
                    for (j = 0; j < a.getNominalValuesList().size(); ++j) {
                        header = header + (String)a.getNominalValuesList().elementAt(j);
                        if (j >= a.getNominalValuesList().size() - 1) continue;
                        header = header + ", ";
                    }
                    header = header + "}\n";
                    continue;
                }
                header = header + "integer [" + String.valueOf((int)a.getMinAttribute()) + ", " + String.valueOf((int)a.getMaxAttribute()) + "]\n";
            }
            file_write.write(header);
            file_write.write(Attributes.getInputHeader() + "\n");
            file_write.write(Attributes.getOutputHeader() + "\n");
            file_write.write("@data\n");
            for (i = 0; i < this.ndatos; ++i) {
                boolean first = true;
                for (j = 0; j < this.nvariables; ++j) {
                    a = Attributes.getAttribute(j);
                    if (!this.usefulAttribute(a)) continue;
                    if (!first) {
                        file_write.write("," + this.X[i][j]);
                        continue;
                    }
                    file_write.write(this.X[i][j]);
                    first = false;
                }
                file_write.write("\n");
            }
            file_write.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }

    public boolean usefulAttribute(Attribute at) {
        if (at.getType() == 0 && at.getNumNominalValues() < 2) {
            return false;
        }
        return at.getType() == 0 || at.getMaxAttribute() != at.getMinAttribute();
    }
}

