/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import kafka.api.RequestOrResponse;
import kafka.network.BlockingChannel$;
import kafka.network.BoundedByteBufferReceive;
import kafka.network.BoundedByteBufferSend;
import kafka.network.Receive;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]s!B\u0001\u0003\u0011\u000b9\u0011a\u0004\"m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7\u000b\u0005\r!\u0011a\u00028fi^|'o\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0005\n\u001b\u0005\u0011a\u0001\u0003\u0006\u0003\t\u0003\u0005\tRA\u0006\u0003\u001f\tcwnY6j]\u001e\u001c\u0005.\u00198oK2\u001c2!\u0003\u0007\u0015!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"aC*dC2\fwJ\u00196fGRDQaG\u0005\u0005\u0002q\ta\u0001P5oSRtD#A\u0004\t\u000fyI!\u0019!C\u0001?\u0005!Rk]3EK\u001a\fW\u000f\u001c;Ck\u001a4WM]*ju\u0016,\u0012\u0001\t\t\u0003+\u0005J!A\t\f\u0003\u0007%sG\u000f\u0003\u0004%\u0013\u0001\u0006I\u0001I\u0001\u0016+N,G)\u001a4bk2$()\u001e4gKJ\u001c\u0016N_3!\r!Q!\u0001\"A\u0001\u0002\u000313\u0003B\u0013\rOQ\u0001\"\u0001K\u0016\u000e\u0003%R!A\u000b\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00051J#a\u0002'pO\u001eLgn\u001a\u0005\t]\u0015\u0012)\u0019!C\u0001_\u0005!\u0001n\\:u+\u0005\u0001\u0004CA\u00195\u001d\t)\"'\u0003\u00024-\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019d\u0003\u0003\u00059K\t\u0005\t\u0015!\u00031\u0003\u0015Awn\u001d;!\u0011!QTE!b\u0001\n\u0003y\u0012\u0001\u00029peRD\u0001\u0002P\u0013\u0003\u0002\u0003\u0006I\u0001I\u0001\u0006a>\u0014H\u000f\t\u0005\t}\u0015\u0012)\u0019!C\u0001?\u0005q!/Z1e\u0005V4g-\u001a:TSj,\u0007\u0002\u0003!&\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u001fI,\u0017\r\u001a\"vM\u001a,'oU5{K\u0002B\u0001BQ\u0013\u0003\u0006\u0004%\taH\u0001\u0010oJLG/\u001a\"vM\u001a,'oU5{K\"AA)\nB\u0001B\u0003%\u0001%\u0001\txe&$XMQ;gM\u0016\u00148+\u001b>fA!Aa)\nBC\u0002\u0013\u0005q$A\u0007sK\u0006$G+[7f_V$Xj\u001d\u0005\t\u0011\u0016\u0012\t\u0011)A\u0005A\u0005q!/Z1e)&lWm\\;u\u001bN\u0004\u0003\"B\u000e&\t\u0003QECB&M\u001b:{\u0005\u000b\u0005\u0002\tK!)a&\u0013a\u0001a!)!(\u0013a\u0001A!)a(\u0013a\u0001A!)!)\u0013a\u0001A!)a)\u0013a\u0001A!9!+\na\u0001\n\u0013\u0019\u0016!C2p]:,7\r^3e+\u0005!\u0006CA\u000bV\u0013\t1fCA\u0004C_>dW-\u00198\t\u000fa+\u0003\u0019!C\u00053\u0006i1m\u001c8oK\u000e$X\rZ0%KF$\"AW/\u0011\u0005UY\u0016B\u0001/\u0017\u0005\u0011)f.\u001b;\t\u000fy;\u0016\u0011!a\u0001)\u0006\u0019\u0001\u0010J\u0019\t\r\u0001,\u0003\u0015)\u0003U\u0003)\u0019wN\u001c8fGR,G\r\t\u0005\bE\u0016\u0002\r\u0011\"\u0003d\u0003\u001d\u0019\u0007.\u00198oK2,\u0012\u0001\u001a\t\u0003K*l\u0011A\u001a\u0006\u0003O\"\f\u0001b\u00195b]:,Gn\u001d\u0006\u0003SB\t1A\\5p\u0013\tYgMA\u0007T_\u000e\\W\r^\"iC:tW\r\u001c\u0005\b[\u0016\u0002\r\u0011\"\u0003o\u0003-\u0019\u0007.\u00198oK2|F%Z9\u0015\u0005i{\u0007b\u00020m\u0003\u0003\u0005\r\u0001\u001a\u0005\u0007c\u0016\u0002\u000b\u0015\u00023\u0002\u0011\rD\u0017M\u001c8fY\u0002Bqa]\u0013A\u0002\u0013%A/A\u0006sK\u0006$7\t[1o]\u0016dW#A;\u0011\u0005\u00154\u0018BA<g\u0005M\u0011V-\u00193bE2,')\u001f;f\u0007\"\fgN\\3m\u0011\u001dIX\u00051A\u0005\ni\fqB]3bI\u000eC\u0017M\u001c8fY~#S-\u001d\u000b\u00035nDqA\u0018=\u0002\u0002\u0003\u0007Q\u000f\u0003\u0004~K\u0001\u0006K!^\u0001\re\u0016\fGm\u00115b]:,G\u000e\t\u0005\t\u007f\u0016\u0002\r\u0011\"\u0003\u0002\u0002\u0005aqO]5uK\u000eC\u0017M\u001c8fYV\u0011\u00111\u0001\t\u0004K\u0006\u0015\u0011bAA\u0004M\n!r)\u0019;iKJLgn\u001a\"zi\u0016\u001c\u0005.\u00198oK2D\u0011\"a\u0003&\u0001\u0004%I!!\u0004\u0002!]\u0014\u0018\u000e^3DQ\u0006tg.\u001a7`I\u0015\fHc\u0001.\u0002\u0010!Ia,!\u0003\u0002\u0002\u0003\u0007\u00111\u0001\u0005\t\u0003')\u0003\u0015)\u0003\u0002\u0004\u0005iqO]5uK\u000eC\u0017M\u001c8fY\u0002B\u0011\"a\u0006&\u0005\u0004%I!!\u0007\u0002\t1|7m[\u000b\u0002\u0019!9\u0011QD\u0013!\u0002\u0013a\u0011!\u00027pG.\u0004\u0003bBA\u0011K\u0011\u0005\u00111E\u0001\bG>tg.Z2u)\u0005Q\u0006bBA\u0014K\u0011\u0005\u00111E\u0001\u000bI&\u001c8m\u001c8oK\u000e$\bBBA\u0016K\u0011\u00051+A\u0006jg\u000e{gN\\3di\u0016$\u0007bBA\u0018K\u0011\u0005\u0011\u0011G\u0001\u0005g\u0016tG\rF\u0002!\u0003gA\u0001\"!\u000e\u0002.\u0001\u0007\u0011qG\u0001\be\u0016\fX/Z:u!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001f\t\u0005\u0019\u0011\r]5\n\t\u0005\u0005\u00131\b\u0002\u0012%\u0016\fX/Z:u\u001fJ\u0014Vm\u001d9p]N,\u0007bBA#K\u0011\u0005\u0011qI\u0001\be\u0016\u001cW-\u001b<f)\t\tI\u0005E\u0002\t\u0003\u0017J1!!\u0014\u0003\u0005\u001d\u0011VmY3jm\u0016D3!JA)!\rA\u00131K\u0005\u0004\u0003+J#!\u00048p]RD'/Z1eg\u00064W\r")
public class BlockingChannel
implements Logging,
ScalaObject {
    private final String host;
    private final int port;
    private final int readBufferSize;
    private final int writeBufferSize;
    private final int readTimeoutMs;
    private boolean connected;
    private SocketChannel kafka$network$BlockingChannel$$channel;
    private ReadableByteChannel kafka$network$BlockingChannel$$readChannel;
    private GatheringByteChannel writeChannel;
    private final Object lock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int UseDefaultBufferSize() {
        return BlockingChannel$.MODULE$.UseDefaultBufferSize();
    }

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        BlockingChannel blockingChannel = this;
        synchronized (blockingChannel) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int readBufferSize() {
        return this.readBufferSize;
    }

    public int writeBufferSize() {
        return this.writeBufferSize;
    }

    public int readTimeoutMs() {
        return this.readTimeoutMs;
    }

    private boolean connected() {
        return this.connected;
    }

    private void connected_$eq(boolean bl) {
        this.connected = bl;
    }

    public final SocketChannel kafka$network$BlockingChannel$$channel() {
        return this.kafka$network$BlockingChannel$$channel;
    }

    private void kafka$network$BlockingChannel$$channel_$eq(SocketChannel socketChannel) {
        this.kafka$network$BlockingChannel$$channel = socketChannel;
    }

    public final ReadableByteChannel kafka$network$BlockingChannel$$readChannel() {
        return this.kafka$network$BlockingChannel$$readChannel;
    }

    private void kafka$network$BlockingChannel$$readChannel_$eq(ReadableByteChannel readableByteChannel) {
        this.kafka$network$BlockingChannel$$readChannel = readableByteChannel;
    }

    private GatheringByteChannel writeChannel() {
        return this.writeChannel;
    }

    private void writeChannel_$eq(GatheringByteChannel gatheringByteChannel) {
        this.writeChannel = gatheringByteChannel;
    }

    private Object lock() {
        return this.lock;
    }

    public void connect() {
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            if (this.connected()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.kafka$network$BlockingChannel$$channel_$eq(SocketChannel.open());
                if (this.readBufferSize() > 0) {
                    this.kafka$network$BlockingChannel$$channel().socket().setReceiveBufferSize(this.readBufferSize());
                }
                if (this.writeBufferSize() > 0) {
                    this.kafka$network$BlockingChannel$$channel().socket().setSendBufferSize(this.writeBufferSize());
                }
                this.kafka$network$BlockingChannel$$channel().configureBlocking(true);
                this.kafka$network$BlockingChannel$$channel().socket().setSoTimeout(this.readTimeoutMs());
                this.kafka$network$BlockingChannel$$channel().socket().setKeepAlive(true);
                this.kafka$network$BlockingChannel$$channel().socket().setTcpNoDelay(true);
                this.kafka$network$BlockingChannel$$channel().connect(new InetSocketAddress(this.host(), this.port()));
                this.writeChannel_$eq(this.kafka$network$BlockingChannel$$channel());
                this.kafka$network$BlockingChannel$$readChannel_$eq(Channels.newChannel(this.kafka$network$BlockingChannel$$channel().socket().getInputStream()));
                this.connected_$eq(true);
                String msg$1 = "Created socket with SO_TIMEOUT = %d (requested %d), SO_RCVBUF = %d (requested %d), SO_SNDBUF = %d (requested %d).";
                this.debug((Function0<String>)new $anonfun$connect$1(this, msg$1));
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void disconnect() {
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            if (!this.connected() && this.kafka$network$BlockingChannel$$channel() == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.swallow((Function0<Object>)new $anonfun$disconnect$1(this));
                this.swallow((Function0<Object>)new $anonfun$disconnect$2(this));
                if (this.kafka$network$BlockingChannel$$readChannel() != null) {
                    this.swallow((Function0<Object>)new $anonfun$disconnect$3(this));
                }
                this.kafka$network$BlockingChannel$$channel_$eq(null);
                this.kafka$network$BlockingChannel$$readChannel_$eq(null);
                this.writeChannel_$eq(null);
                this.connected_$eq(false);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public boolean isConnected() {
        return this.connected();
    }

    public int send(RequestOrResponse request) {
        if (this.connected()) {
            BoundedByteBufferSend send2 = new BoundedByteBufferSend(request);
            return send2.writeCompletely(this.writeChannel());
        }
        throw new ClosedChannelException();
    }

    /*
     * WARNING - void declaration
     */
    public Receive receive() {
        if (this.connected()) {
            void var1_1;
            BoundedByteBufferReceive response = new BoundedByteBufferReceive();
            response.readCompletely(this.kafka$network$BlockingChannel$$readChannel());
            return var1_1;
        }
        throw new ClosedChannelException();
    }

    public BlockingChannel(String host, int port, int readBufferSize, int writeBufferSize, int readTimeoutMs) {
        this.host = host;
        this.port = port;
        this.readBufferSize = readBufferSize;
        this.writeBufferSize = writeBufferSize;
        this.readTimeoutMs = readTimeoutMs;
        Logging$class.$init$(this);
        this.connected = false;
        this.kafka$network$BlockingChannel$$channel = null;
        this.kafka$network$BlockingChannel$$readChannel = null;
        this.writeChannel = null;
        this.lock = new Object();
    }
}

