## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(read.gt3x)

## -----------------------------------------------------------------------------
gt3xfile <-
  system.file(
    "extdata", "TAS1H30182785_2019-09-17.gt3x",
    package = "read.gt3x")

## ----download, eval = FALSE---------------------------------------------------
#  gt3xfile <- gt3x_datapath(1)

## -----------------------------------------------------------------------------
X <- read.gt3x(gt3xfile)

## -----------------------------------------------------------------------------
head(X)

## ---- echo = FALSE------------------------------------------------------------
rm(X); gc(); gc()

## -----------------------------------------------------------------------------
datadir <- dirname(gt3xfile) # location of .gt3x files
gt3xfolders <- unzip.gt3x(datadir, location = tempdir())

## -----------------------------------------------------------------------------
gt3xfolder <- gt3xfolders[1]
X <- read.gt3x(gt3xfolder)

## -----------------------------------------------------------------------------
head(X)

## -----------------------------------------------------------------------------
str(X)

## -----------------------------------------------------------------------------
X <- as.data.frame(X)
head(X)

## ---- echo = FALSE------------------------------------------------------------
rm(X); gc(); gc()

