/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.dictionary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.dictionary.DictionaryBuilderParams;
import opennlp.tools.dictionary.Dictionary;

public class DictionaryBuilderTool
extends BasicCmdLineTool {
    public String getShortDescription() {
        return "builds a new dictionary";
    }

    public String getHelp() {
        return this.getBasicHelp(Params.class);
    }

    public void run(String[] args) {
        Params params = this.validateAndParseParams(args, Params.class);
        File dictInFile = params.getInputFile();
        File dictOutFile = params.getOutputFile();
        Charset encoding = params.getEncoding();
        CmdLineUtil.checkInputFile("dictionary input file", dictInFile);
        CmdLineUtil.checkOutputFile("dictionary output file", dictOutFile);
        InputStreamReader in = null;
        OutputStream out = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(dictInFile), encoding);
            out = new FileOutputStream(dictOutFile);
            Dictionary dict = Dictionary.parseOneEntryPerLine(in);
            dict.serialize(out);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (IOException e) {}
        }
    }

    static interface Params
    extends DictionaryBuilderParams {
    }
}

