/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.delta;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.iterators.IntArrayIterator;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.variables.delta.IDeltaDomain;

public final class BipartiteDeltaDomain
implements IDeltaDomain {
    private int beginningOfDeltaDomain;
    private int endOfDeltaDomain;
    private final IStateInt valuesInDomainNumber;
    private final int[] values;

    public BipartiteDeltaDomain(int size, int[] theValues, IStateInt theValuesInDomainNumber) {
        this.endOfDeltaDomain = size;
        this.beginningOfDeltaDomain = size;
        this.values = theValues;
        this.valuesInDomainNumber = theValuesInDomainNumber;
    }

    @Override
    public void freeze() {
        this.beginningOfDeltaDomain = this.valuesInDomainNumber.get() + 1;
    }

    @Override
    public void remove(int value) {
        if (this.endOfDeltaDomain <= value) {
            this.endOfDeltaDomain = value + 1;
        }
    }

    @Override
    public void clear() {
        this.endOfDeltaDomain = this.beginningOfDeltaDomain = this.valuesInDomainNumber.get() + 1;
    }

    @Override
    public boolean isReleased() {
        return this.beginningOfDeltaDomain == this.endOfDeltaDomain;
    }

    @Override
    public boolean release() {
        this.endOfDeltaDomain = this.beginningOfDeltaDomain;
        this.beginningOfDeltaDomain = this.valuesInDomainNumber.get() + 1;
        return this.beginningOfDeltaDomain == this.endOfDeltaDomain;
    }

    @Override
    public DisposableIntIterator iterator() {
        return IntArrayIterator.getIterator(this.values, this.beginningOfDeltaDomain, this.endOfDeltaDomain);
    }

    @Override
    public IDeltaDomain copy() {
        return new BipartiteDeltaDomain(this.endOfDeltaDomain, this.values, null);
    }

    @Override
    public String pretty() {
        return this.beginningOfDeltaDomain + " -> " + this.endOfDeltaDomain;
    }
}

