/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives;

import java.util.Set;
import org.corehunter.data.CoreHunterData;
import org.corehunter.data.FrequencyGenotypeData;
import org.corehunter.exceptions.CoreHunterException;
import org.corehunter.objectives.eval.CoverageEvaluation;
import org.jamesframework.core.exceptions.IncompatibleDeltaEvaluationException;
import org.jamesframework.core.problems.objectives.Objective;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;
import org.jamesframework.core.search.neigh.Move;
import org.jamesframework.core.subset.SubsetSolution;
import org.jamesframework.core.subset.neigh.moves.SubsetMove;

public class Coverage
implements Objective<SubsetSolution, CoreHunterData> {
    public CoverageEvaluation evaluate(SubsetSolution solution, CoreHunterData data) {
        FrequencyGenotypeData genotypes = data.getGenotypicData();
        if (genotypes == null) {
            throw new CoreHunterException("Genotypes are required for coverage objective.");
        }
        return new CoverageEvaluation(solution.getSelectedIDs(), genotypes);
    }

    public CoverageEvaluation evaluate(Move move, SubsetSolution curSolution, Evaluation curEvaluation, CoreHunterData data) {
        if (!(move instanceof SubsetMove)) {
            throw new IncompatibleDeltaEvaluationException("Coveage objective should be used in combination with neighbourhoods that generate moves of type SubsetMove.");
        }
        SubsetMove subsetMove = (SubsetMove)move;
        CoverageEvaluation eval = (CoverageEvaluation)curEvaluation;
        Set<Integer> added = subsetMove.getAddedIDs();
        Set<Integer> deleted = subsetMove.getDeletedIDs();
        return new CoverageEvaluation(eval, added, deleted, data.getGenotypicData());
    }

    @Override
    public boolean isMinimizing() {
        return false;
    }

    public String toString() {
        return "Coverage";
    }
}

