/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import java.util.EmptyStackException;
import javax.realtime.MemoryArea;
import javolution.JavolutionError;
import javolution.realtime.ConcurrentContext;
import javolution.realtime.HeapContext;
import javolution.realtime.LocalContext;
import javolution.realtime.PoolContext;

public abstract class Context {
    private static final ThreadLocal CURRENT = new ThreadLocal(){

        protected Object initialValue() {
            Thread thread = Thread.currentThread();
            HeapContext heapContext = new HeapContext();
            ((Context)heapContext)._owner = thread;
            return heapContext;
        }
    };
    transient PoolContext inheritedPoolContext;
    transient LocalContext inheritedLocalContext;
    private transient Thread _owner;
    private transient Context _outer;
    private Context _inner;

    protected Context() {
    }

    public static Context current() {
        return (Context)CURRENT.get();
    }

    public final Thread getOwner() {
        return this._owner;
    }

    public final Context getOuter() {
        return this._outer;
    }

    public void clear() {
        if (this._inner != null) {
            this._inner.clear();
        }
        this._inner = null;
    }

    protected abstract void enterAction();

    protected abstract void exitAction();

    public static void enter(Context context) {
        Context context2;
        if (context._owner != null) {
            throw new IllegalStateException("Context is currently in use");
        }
        context._outer = context2 = Context.current();
        context._owner = context2._owner;
        CURRENT.set(context);
        context.inheritedPoolContext = context2.inheritedPoolContext;
        context.inheritedLocalContext = context2.inheritedLocalContext;
        context.enterAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(Context context) {
        if (context._owner != Thread.currentThread()) {
            throw new IllegalStateException("Context is not used by the current thread");
        }
        if (context._outer == null || context._outer._owner != context._owner) {
            throw new EmptyStackException();
        }
        try {
            context.exitAction();
        }
        finally {
            CURRENT.set(context._outer);
            context._outer = null;
            context._owner = null;
        }
    }

    protected static Context enter(Class clazz) {
        Context context;
        Context context2 = context = Context.current();
        Context context3 = context._inner;
        while (context3 != null) {
            if (clazz.equals(context3.getClass())) {
                context2._inner = context3._inner;
                break;
            }
            context2 = context3;
            context3 = context3._inner;
        }
        if (context3 == null) {
            try {
                context3 = (Context)MemoryArea.getMemoryArea(context2).newInstance(clazz);
            }
            catch (InstantiationException instantiationException) {
                throw new JavolutionError(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JavolutionError(illegalAccessException);
            }
        }
        context3._inner = context._inner;
        context._inner = context3;
        context3._outer = context;
        context3._owner = context._owner;
        context3.inheritedPoolContext = context.inheritedPoolContext;
        context3.inheritedLocalContext = context.inheritedLocalContext;
        CURRENT.set(context3);
        context3.enterAction();
        return context3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Context exit(Class clazz) {
        Context context = Context.current();
        if (!clazz.isInstance(context)) {
            throw new IllegalStateException("Current context is not an instance of " + clazz);
        }
        Context context2 = context._outer;
        if (context2 == null || context2._owner != context._owner) {
            throw new EmptyStackException();
        }
        try {
            context.exitAction();
            Context context3 = context;
            return context3;
        }
        finally {
            CURRENT.set(context2);
            context._outer = null;
            context._owner = null;
        }
    }

    static void setCurrent(PoolContext poolContext, ConcurrentContext concurrentContext) {
        poolContext._outer = concurrentContext;
        poolContext._owner = Thread.currentThread();
        CURRENT.set(poolContext);
        poolContext.inheritedPoolContext = poolContext;
        poolContext.inheritedLocalContext = concurrentContext.inheritedLocalContext;
    }
}

