/*
 * Decompiled with CFR 0.152.
 */
package epp_pso;

import epp_pso.ParametrePSO;
import epp_pso.Particule;
import indice.Indice;
import javalain.math.Calcul;

public class Essaim {
    private final Particule[] swarm;
    private final int nbParticules;
    private final ParametrePSO parametrePSO;

    public Essaim(ParametrePSO pso, Indice indice, int nb) {
        this.parametrePSO = pso;
        this.nbParticules = nb;
        this.swarm = new Particule[this.nbParticules];
        for (int i = 0; i < this.nbParticules; ++i) {
            this.swarm[i] = new Particule(indice);
        }
    }

    public int getTaille() {
        return this.nbParticules;
    }

    public void calculMeilleurePosition() {
        for (int i = 0; i < this.nbParticules; ++i) {
            this.swarm[i].calculMeilleurePosition();
        }
    }

    public void calculNouvellePosition() {
        int i;
        if (this.parametrePSO.getVoisinage().equals("VOISINAGE_COSINUS")) {
            for (i = 0; i < this.nbParticules; ++i) {
                this.swarm[i].meilleureProjectionVoisine = this.swarm[this.voisinageCosinus((int)i)].meilleureProjection;
            }
        } else if (this.parametrePSO.getVoisinage().equals("VOISINAGE_GLOBAL")) {
            int i2;
            int k = 0;
            double maximum = this.swarm[0].meilleurI;
            for (i2 = 0; i2 < this.nbParticules; ++i2) {
                if (!(this.swarm[i2].meilleurI > maximum)) continue;
                maximum = this.swarm[i2].meilleurI;
                k = i2;
            }
            for (i2 = 0; i2 < this.nbParticules; ++i2) {
                this.swarm[i2].meilleureProjectionVoisine = this.swarm[k].meilleureProjection;
            }
        } else if (this.parametrePSO.getVoisinage().equals("SANS_VOISINAGE")) {
            for (i = 0; i < this.nbParticules; ++i) {
                this.swarm[i].meilleureProjectionVoisine = this.swarm[i].meilleureProjection;
            }
        }
        for (i = 0; i < this.nbParticules; ++i) {
            this.swarm[i].calculNouvellePosition();
        }
    }

    public Particule getMeilleureParticule() {
        int pos = 0;
        double max = this.swarm[0].meilleurI;
        for (int i = 1; i < this.nbParticules; ++i) {
            if (!(max < this.swarm[i].meilleurI)) continue;
            pos = i;
            max = this.swarm[i].meilleurI;
        }
        return this.swarm[pos];
    }

    private int voisinageCosinus(int pos) {
        int nb_voisins = 0;
        int k = pos;
        double max = this.swarm[pos].meilleurI;
        double[] proj = this.swarm[pos].projectionCourante;
        for (int i = 0; i < this.nbParticules; ++i) {
            double angle = Calcul.arcCosinus(proj, this.swarm[i].projectionCourante);
            if (!(angle < 0.5235987755982988) && !(angle > 2.6179938779914944) || nb_voisins >= 2 || pos == i) continue;
            ++nb_voisins;
            if (!(this.swarm[i].meilleurI > max)) continue;
            max = this.swarm[i].meilleurI;
            k = i;
        }
        return k;
    }
}

