/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.map.tlong.AbstractLongLongMap;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.SelectedSparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;

class SelectedSparseLongMatrix2D
extends LongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongLongMap elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseLongMatrix2D(AbstractLongLongMap abstractLongLongMap, int[] nArray, int[] nArray2, int n) {
        this(nArray.length, nArray2.length, abstractLongLongMap, 0, 0, 1, 1, nArray, nArray2, n);
    }

    protected SelectedSparseLongMatrix2D(int n, int n2, AbstractLongLongMap abstractLongLongMap, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = abstractLongLongMap;
        this.rowOffsets = nArray;
        this.columnOffsets = nArray2;
        this.offset = n7;
        this.isNoView = false;
    }

    public AbstractLongLongMap elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public long getQuick(int n, int n2) {
        return this.elements.get((long)this.offset + (long)this.rowOffsets[this.rowZero + n * this.rowStride] + (long)this.columnOffsets[this.columnZero + n2 * this.columnStride]);
    }

    public long index(int n, int n2) {
        return (long)this.offset + (long)this.rowOffsets[this.rowZero + n * this.rowStride] + (long)this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    public LongMatrix2D like(int n, int n2) {
        return new SparseLongMatrix2D(n, n2);
    }

    public LongMatrix1D like1D(int n) {
        return new SparseLongMatrix1D(n);
    }

    public void setQuick(int n, int n2, long l) {
        long l2 = (long)this.offset + (long)this.rowOffsets[this.rowZero + n * this.rowStride] + (long)this.columnOffsets[this.columnZero + n2 * this.columnStride];
        if (l == 0L) {
            this.elements.removeKey(l2);
        } else {
            this.elements.put(l2, l);
        }
    }

    public LongMatrix1D vectorize() {
        SparseLongMatrix1D sparseLongMatrix1D = new SparseLongMatrix1D((int)this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                sparseLongMatrix1D.setQuick(n++, this.getQuick(i, j));
            }
        }
        return sparseLongMatrix1D;
    }

    public LongMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedSparseLongMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    public LongMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedSparseLongMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected boolean haveSharedCellsRaw(LongMatrix2D longMatrix2D) {
        if (longMatrix2D instanceof SelectedSparseLongMatrix2D) {
            SelectedSparseLongMatrix2D selectedSparseLongMatrix2D = (SelectedSparseLongMatrix2D)longMatrix2D;
            return this.elements == selectedSparseLongMatrix2D.elements;
        }
        if (longMatrix2D instanceof SparseLongMatrix2D) {
            SparseLongMatrix2D sparseLongMatrix2D = (SparseLongMatrix2D)longMatrix2D;
            return this.elements == sparseLongMatrix2D.elements;
        }
        return false;
    }

    protected LongMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    protected LongMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseLongMatrix2D(this.elements, nArray, nArray2, this.offset);
    }
}

