/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.parser;

import com.amazon.sqlengine.exceptions.SQLEngineException;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.exceptions.DiagState;

public final class PTParseErrorInfo {
    private static final String SYNTAX_ERROR_MARKER = "<<< ??? >>>";

    private PTParseErrorInfo() {
        throw new UnsupportedOperationException("Not instantiable");
    }

    public static SQLEngineException makeSyntaxError(String string, int n) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.SYNTAX_ERROR.name(), new String[]{String.valueOf(n), PTParseErrorInfo.errorPositionString(string, n)});
        return sQLEngineException;
    }

    public static SQLEngineException makeInvalidSqlTypeError(String string, String string2, int n) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_SQL_TYPE.name(), new String[]{String.valueOf(n), string2, PTParseErrorInfo.errorPositionString(string, n)});
        return sQLEngineException;
    }

    private static String errorPositionString(String string, int n) {
        n = Math.max(Math.min(n, string.length()), 0);
        return string.substring(0, n) + SYNTAX_ERROR_MARKER + string.substring(n);
    }
}

