/*
 * Decompiled with CFR 0.152.
 */
package dr.math.functionEval;

import dr.math.interfaces.OneVariableFunction;

public final class FunctionDerivative
implements OneVariableFunction {
    private OneVariableFunction f;
    private double relativePrecision = 1.0E-4;

    public FunctionDerivative(OneVariableFunction oneVariableFunction) {
        this(oneVariableFunction, 1.0E-6);
    }

    public FunctionDerivative(OneVariableFunction oneVariableFunction, double d) {
        this.f = oneVariableFunction;
        this.relativePrecision = d;
    }

    @Override
    public double value(double d) {
        double d2 = d == 0.0 ? this.relativePrecision : d * (1.0 + this.relativePrecision);
        double d3 = 2.0 * d - d2;
        return (this.f.value(d2) - this.f.value(d3)) / (d2 - d3);
    }
}

