
library(ALS)
library(TIMP)

x2 <- 50:449  

x <-  5720:5800

Cmodel <- mass()
Cmodel@x <- x 
Cmodel@nt <- length(x)
Cmodel@extracomp <- FALSE

Cparam <- theta()

snr <- 1000

ntimes <- 100

ans <- array(dim=c(ntimes,2,2))

S <- as.matrix(read.table("S.R"))

set.seed(10)

for(i in 1:ntimes) {
  cat("********************************\n")
  cat("Noise realization",i,"\n")
  cat("********************************\n")
  
  Cparam@peakpar <- list(c(5754,7,1),c(5755,7,1)) 
  
  Cparam@amplitudes <- a1 <- c(1,2)
  C1 <- compModelMass(Cparam, Cmodel)
  
  Cparam@amplitudes <- a2 <- c(1.5,2)

  C2 <- compModelMass(Cparam, Cmodel)
                                        
  Cst <- theta()
  
  Cst@peakpar <- list(c(5757,7,1),c(5753,7,1)) 
  
  Cst@amplitudes<-a1
  C1s <- compModelMass(Cst, Cmodel)
  Cst@amplitudes<-a2
  C2s <- compModelMass(Cst, Cmodel)
  
  mc <- initModel(mod_type = "mass",
                  positivepar=c("amplitudes"), 
                  peakpar =Cst@peakpar, amplitudes=a1,
                  extracomp=FALSE, fixed = list(amplitudes=1:2))
     
  xx1 <- C1 %*% t(S)
  xx2 <- C2 %*% t(S)
  
  Cxx1<-snr^2 * (C1s/max(xx1))
  Cxx2<- snr^2 * (C2s/max(xx2))
  
  xx1 <- snr^2 * (xx1/max(xx1))
  xx2 <- snr^2 * (xx2/max(xx2))
  d1 <- rpois(length(xx1),xx1)
  d2 <- rpois(length(xx2),xx2)
  dim(d1)<-dim(xx1)
  dim(d2)<-dim(xx2)
  datList<-list()
  datList[[1]] <- dat(psi.df = d1,x = x, x2 = x2, 
                      nt = length(x), nl = length(x2), simdata = FALSE)
  datList[[2]] <- dat(psi.df = d2,x = x, x2 = x2, 
                      nt = length(x), nl = length(x2), simdata = FALSE)

  test0  <- try(als(CList=list(Cxx1,Cxx2),
                    PsiList=list(d1,d2), S=S,normS=1,
                    uniC = TRUE, optS1st=TRUE))
 
  test1 <- try(fitModel(data=datList,modspec=list(mc),
                        modeldiffs = list(change = list(
                             list(what = "fixed", dataset=2,
                             spec = list()),
                    list(what = "amplitudes", dataset = 2, spec = a2))),
                        opt=massopt(iter=50, nnls=TRUE, sumnls=FALSE,
                            algorithm="nls.lm", nummaxtraces=100, plot=FALSE)))
  if(class(test1)!="try-error") {
    S1 <- getSpecList(test1$currModel, test1$currTheta)[[1]]
    if( matchFactor(S[,1],S1[,1]) >  matchFactor(S[,1],S1[,2]) ) {
      ans[i,1,1] <- matchFactor(S[,1],S1[,1])
      ans[i,2,1] <- matchFactor(S[,2],S1[,2])
    }
    else {
      ans[i,1,1] <- matchFactor(S[,1],S1[,2])
      ans[i,2,1] <- matchFactor(S[,2],S1[,1])
    }
  }
  if(class(test0)!="try-error") {
    S2 <- test0$S
    if( matchFactor(S[,1],S2[,1]) >  matchFactor(S[,1],S2[,2]) ) { 
      ans[i,1,2] <- matchFactor(S[,1],S2[,1])
      ans[i,2,2] <- matchFactor(S[,2],S2[,2])
    }
    else{
      ans[i,1,2] <- matchFactor(S[,1],S2[,2])
      ans[i,2,2] <- matchFactor(S[,2],S2[,1])
    }
  }
  bigTMPAB<-ans
  save(bigTMPAB,file="bigTMPAB.R")
  
}
sameshapeAB<-ans
save(sameshapeAB,file="sameshapeAB.R")

#########################################################
##### FIGURES
#########################################################

## matching factor results 

pdf("MF.pdf")

par(mfrow=c(2,1),cex=1.25, mar=c(4,5,3,2))

plot(1:ntimes,ans[,1,1],ylab="matching factor",
     xlab="noise realization", ylim=c(.5,1),pch=18,col=grey(c(.1)),
     main="Global analysis")

points(1:ntimes,ans[,2,1],ylab="matching factor",
     xlab="noise realization", ylim=c(.5,1),pch=20,col=grey(c(.5)))

plot(1:ntimes,ans[,1,2],ylab="matching factor",
     xlab="noise realization", ylim=c(.5,1),pch=18,col=grey(c(.1)),
     main="MCR-ALS")

points(1:ntimes,ans[,2,2],ylab="matching factor",
     xlab="noise realization", ylim=c(.5,1),pch=20,col=grey(c(.5)))

dev.off()

## Estimated spectra

plotS(cbind(S,S1,S2), out=TRUE,file="ES.pdf",col=grey(c(.1,.5,.1,.5,.1,.5)))

## Mass spectra

plotS(S,x2,out=TRUE,filename="S.pdf",col=grey(c(.1,.5)))

## Elution profiles

colg <- hcl(.1,.1,.1,.1)

pdf("C.pdf", width=28,height=7)

par(mfrow=c(1,2),mar=c(0,0,0,0), oma=c(2,0,0,0),cex=4)
matplot(x,C1,type="l", xaxt="n", yaxt="n", lty=1, ylim=c(0, max(C1)),
        col=1)
polygon(x,C1[,1],col=colg)
polygon(x,C1[,2],col= colg)

axis(1,at=c(5740,5760,5780))

matplot(x,C2,type="l", xaxt="n", yaxt="n", lty=1, ylim=c(0, max(C2)),
        col=1)
polygon(x,C2[,1],col=colg)
polygon(x,C2[,2],col= colg)

axis(1,at=c(5740,5760,5780))

dev.off()

## Data

library(lattice)

pdf("D.pdf")

trellis.device(color=FALSE,new=FALSE)

par.set <- list(axis.line = list(col = "transparent"),
                clip = list(panel = "off"))

wireframe(row.values=x,column.values=x2,x=d2,aspect=c(1,1),
          par.settings = par.set,         
          ylab=list("m/z",cex=1.7),shade=TRUE,#col.regions=cs,
          xlab=list("time",cex=1.7), zlab="",scales = list(arrows = FALSE,
          cex=1.3, cex.lab=2, col="black", font= 3, tck=1, rot=c(45),
          x=list(rot=0), y=list(rot=0)))

dev.off()

