## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)


iris <- tibble::tibble(iris)

## ----setup--------------------------------------------------------------------
library(validata)
library(tidyselect)

## -----------------------------------------------------------------------------
head(sample_data1)

## -----------------------------------------------------------------------------
sample_data1 %>% 
  confirm_distinct(ID_COL1)

## -----------------------------------------------------------------------------
sample_data1 %>% 
  confirm_distinct(ID_COL1, ID_COL2)

## -----------------------------------------------------------------------------
sample_data1 %>% 
  confirm_distinct(ID_COL1, ID_COL2, ID_COL3)

## -----------------------------------------------------------------------------
sample_data1 %>% 
  determine_distinct(matches("ID"))

## -----------------------------------------------------------------------------
sample_data1 %>% 
  confirm_mapping(ID_COL1, ID_COL2, view = F)

## -----------------------------------------------------------------------------
sample_data1 %>% 
  determine_mapping(everything())

## -----------------------------------------------------------------------------

confirm_overlap(iris$Sepal.Width, iris$Petal.Length) -> iris_overlap


## -----------------------------------------------------------------------------
print(iris_overlap)

## -----------------------------------------------------------------------------
iris_overlap %>% 
  co_find_only_in_1() %>% 
  head()


## -----------------------------------------------------------------------------
iris_overlap %>% 
  co_find_only_in_2() %>% 
  head()

## -----------------------------------------------------------------------------
iris_overlap %>% 
  co_find_in_both() %>% 
  head()

## ----eval=FALSE, include=FALSE------------------------------------------------
#  iris %>%
#    determine_overlap(everything())

## -----------------------------------------------------------------------------
iris %>% 
  confirm_strlen(Species) -> species_len

## -----------------------------------------------------------------------------
head(species_len)

## -----------------------------------------------------------------------------
species_len %>% 
  choose_strlen(len = 6) %>% 
  head()

## -----------------------------------------------------------------------------
iris %>% 
  diagnose()

